package de.flapdoodle.eval.core.evaluables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Signature}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSignature.builder()}.
 */
@Generated(from = "Signature", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSignature<T> extends Signature<T> {
  private final List<Parameter<?>> parameters;
  private final boolean isVarArg;
  private final Class<T> returnType;
  private transient final int minNumberOfArguments;
  private transient final int maxNumberOfArguments;

  private ImmutableSignature(ImmutableSignature.Builder<T> builder) {
    this.parameters = createUnmodifiableList(true, builder.parameters);
    this.returnType = builder.returnType;
    if (builder.isVarArgIsSet()) {
      initShim.isVarArg(builder.isVarArg);
    }
    this.isVarArg = initShim.isVarArg();
    this.minNumberOfArguments = initShim.minNumberOfArguments();
    this.maxNumberOfArguments = initShim.maxNumberOfArguments();
    this.initShim = null;
  }

  private ImmutableSignature(
      List<Parameter<?>> parameters,
      boolean isVarArg,
      Class<T> returnType) {
    this.parameters = parameters;
    initShim.isVarArg(isVarArg);
    this.returnType = returnType;
    this.isVarArg = initShim.isVarArg();
    this.minNumberOfArguments = initShim.minNumberOfArguments();
    this.maxNumberOfArguments = initShim.maxNumberOfArguments();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Signature", generator = "Immutables")
  private final class InitShim {
    private byte isVarArgBuildStage = STAGE_UNINITIALIZED;
    private boolean isVarArg;

    boolean isVarArg() {
      if (isVarArgBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isVarArgBuildStage == STAGE_UNINITIALIZED) {
        isVarArgBuildStage = STAGE_INITIALIZING;
        this.isVarArg = ImmutableSignature.super.isVarArg();
        isVarArgBuildStage = STAGE_INITIALIZED;
      }
      return this.isVarArg;
    }

    void isVarArg(boolean isVarArg) {
      this.isVarArg = isVarArg;
      isVarArgBuildStage = STAGE_INITIALIZED;
    }

    private byte minNumberOfArgumentsBuildStage = STAGE_UNINITIALIZED;
    private int minNumberOfArguments;

    int minNumberOfArguments() {
      if (minNumberOfArgumentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (minNumberOfArgumentsBuildStage == STAGE_UNINITIALIZED) {
        minNumberOfArgumentsBuildStage = STAGE_INITIALIZING;
        this.minNumberOfArguments = ImmutableSignature.super.minNumberOfArguments();
        minNumberOfArgumentsBuildStage = STAGE_INITIALIZED;
      }
      return this.minNumberOfArguments;
    }

    private byte maxNumberOfArgumentsBuildStage = STAGE_UNINITIALIZED;
    private int maxNumberOfArguments;

    int maxNumberOfArguments() {
      if (maxNumberOfArgumentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (maxNumberOfArgumentsBuildStage == STAGE_UNINITIALIZED) {
        maxNumberOfArgumentsBuildStage = STAGE_INITIALIZING;
        this.maxNumberOfArguments = ImmutableSignature.super.maxNumberOfArguments();
        maxNumberOfArgumentsBuildStage = STAGE_INITIALIZED;
      }
      return this.maxNumberOfArguments;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (isVarArgBuildStage == STAGE_INITIALIZING) attributes.add("isVarArg");
      if (minNumberOfArgumentsBuildStage == STAGE_INITIALIZING) attributes.add("minNumberOfArguments");
      if (maxNumberOfArgumentsBuildStage == STAGE_INITIALIZING) attributes.add("maxNumberOfArguments");
      return "Cannot build Signature, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public List<Parameter<?>> parameters() {
    return parameters;
  }

  /**
   * @return The value of the {@code isVarArg} attribute
   */
  @Override
  public boolean isVarArg() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isVarArg()
        : this.isVarArg;
  }

  /**
   * @return The value of the {@code returnType} attribute
   */
  @Override
  public Class<T> returnType() {
    return returnType;
  }

  /**
   * @return The computed-at-construction value of the {@code minNumberOfArguments} attribute
   */
  @Override
  public int minNumberOfArguments() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.minNumberOfArguments()
        : this.minNumberOfArguments;
  }

  /**
   * @return The computed-at-construction value of the {@code maxNumberOfArguments} attribute
   */
  @Override
  public int maxNumberOfArguments() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.maxNumberOfArguments()
        : this.maxNumberOfArguments;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Signature#parameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableSignature<T> withParameters(Parameter<?>... elements) {
    List<Parameter<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableSignature<>(newValue, this.isVarArg, this.returnType);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Signature#parameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSignature<T> withParameters(Iterable<? extends Parameter<?>> elements) {
    if (this.parameters == elements) return this;
    List<Parameter<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableSignature<>(newValue, this.isVarArg, this.returnType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Signature#isVarArg() isVarArg} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isVarArg
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignature<T> withIsVarArg(boolean value) {
    if (this.isVarArg == value) return this;
    return new ImmutableSignature<>(this.parameters, value, this.returnType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Signature#returnType() returnType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for returnType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignature<T> withReturnType(Class<T> value) {
    if (this.returnType == value) return this;
    Class<T> newValue = Objects.requireNonNull(value, "returnType");
    return new ImmutableSignature<>(this.parameters, this.isVarArg, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSignature} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSignature<?>
        && equalTo(0, (ImmutableSignature<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableSignature<?> another) {
    return parameters.equals(another.parameters)
        && isVarArg == another.isVarArg
        && returnType.equals(another.returnType)
        && minNumberOfArguments == another.minNumberOfArguments
        && maxNumberOfArguments == another.maxNumberOfArguments;
  }

  /**
   * Computes a hash code from attributes: {@code parameters}, {@code isVarArg}, {@code returnType}, {@code minNumberOfArguments}, {@code maxNumberOfArguments}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + parameters.hashCode();
    h += (h << 5) + Boolean.hashCode(isVarArg);
    h += (h << 5) + returnType.hashCode();
    h += (h << 5) + minNumberOfArguments;
    h += (h << 5) + maxNumberOfArguments;
    return h;
  }

  /**
   * Prints the immutable value {@code Signature} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Signature{"
        + "parameters=" + parameters
        + ", isVarArg=" + isVarArg
        + ", returnType=" + returnType
        + ", minNumberOfArguments=" + minNumberOfArguments
        + ", maxNumberOfArguments=" + maxNumberOfArguments
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Signature} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Signature instance
   */
  public static <T> ImmutableSignature<T> copyOf(Signature<T> instance) {
    if (instance instanceof ImmutableSignature<?>) {
      return (ImmutableSignature<T>) instance;
    }
    return ImmutableSignature.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSignature ImmutableSignature}.
   * <pre>
   * ImmutableSignature.&amp;lt;T&amp;gt;builder()
   *    .addParameters|addAllParameters(de.flapdoodle.eval.core.evaluables.Parameter&amp;lt;?&amp;gt;) // {@link Signature#parameters() parameters} elements
   *    .isVarArg(boolean) // optional {@link Signature#isVarArg() isVarArg}
   *    .returnType(Class&amp;lt;T&amp;gt;) // required {@link Signature#returnType() returnType}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @param returnType {@code returnType} parameter
   * @return A new ImmutableSignature builder
   */
  public static <T> ImmutableSignature.Builder<T> builder(Class<T> returnType) {
    return new ImmutableSignature.Builder<>(returnType);
  }

  static <T> ImmutableSignature.Builder<T> builder() {
    return new ImmutableSignature.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableSignature ImmutableSignature}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Signature", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_RETURN_TYPE = 0x1L;
    private static final long OPT_BIT_IS_VAR_ARG = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private List<Parameter<?>> parameters = new ArrayList<Parameter<?>>();
    private boolean isVarArg;
    private Class<T> returnType;

    private Builder(Class<T> returnType) {
      returnType(returnType);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Signature} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Signature<T> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllParameters(instance.parameters());
      this.isVarArg(instance.isVarArg());
      this.returnType(instance.returnType());
      return this;
    }

    /**
     * Adds one element to {@link Signature#parameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addParameters(Parameter<?> element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      return this;
    }

    /**
     * Adds elements to {@link Signature#parameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addParameters(Parameter<?>... elements) {
      for (Parameter<?> element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Signature#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> parameters(Iterable<? extends Parameter<?>> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link Signature#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllParameters(Iterable<? extends Parameter<?>> elements) {
      for (Parameter<?> element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Signature#isVarArg() isVarArg} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Signature#isVarArg() isVarArg}.</em>
     * @param isVarArg The value for isVarArg 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> isVarArg(boolean isVarArg) {
      this.isVarArg = isVarArg;
      optBits |= OPT_BIT_IS_VAR_ARG;
      return this;
    }

    /**
     * Initializes the value for the {@link Signature#returnType() returnType} attribute.
     * @param returnType The value for returnType 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<T> returnType(Class<T> returnType) {
      this.returnType = Objects.requireNonNull(returnType, "returnType");
      initBits &= ~INIT_BIT_RETURN_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSignature ImmutableSignature}.
     * @return An immutable instance of Signature
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSignature<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSignature<T>(this);
    }

    private boolean isVarArgIsSet() {
      return (optBits & OPT_BIT_IS_VAR_ARG) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_RETURN_TYPE) != 0) attributes.add("returnType");
      return "Cannot build Signature, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
