package de.flapdoodle.eval.core.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Token}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToken.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableToken.of()}.
 */
@Generated(from = "Token", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableToken implements Token {
  private final int start;
  private final String value;
  private final TokenType type;

  private ImmutableToken(int start, String value, TokenType type) {
    this.start = start;
    this.value = Objects.requireNonNull(value, "value");
    this.type = Objects.requireNonNull(type, "type");
  }

  private ImmutableToken(
      ImmutableToken original,
      int start,
      String value,
      TokenType type) {
    this.start = start;
    this.value = value;
    this.type = type;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @Override
  public int start() {
    return start;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public String value() {
    return value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TokenType type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#start() start} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withStart(int value) {
    if (this.start == value) return this;
    return new ImmutableToken(this, value, this.value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#value() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableToken(this, this.start, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Token#type() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToken withType(TokenType value) {
    TokenType newValue = Objects.requireNonNull(value, "type");
    if (this.type == newValue) return this;
    return new ImmutableToken(this, this.start, this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToken} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToken
        && equalTo(0, (ImmutableToken) another);
  }

  private boolean equalTo(int synthetic, ImmutableToken another) {
    return start == another.start
        && value.equals(another.value)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code start}, {@code value}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + start;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Token} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Token{"
        + "start=" + start
        + ", value=" + value
        + ", type=" + type
        + "}";
  }

  /**
   * Construct a new immutable {@code Token} instance.
   * @param start The value for the {@code start} attribute
   * @param value The value for the {@code value} attribute
   * @param type The value for the {@code type} attribute
   * @return An immutable Token instance
   */
  public static ImmutableToken of(int start, String value, TokenType type) {
    return new ImmutableToken(start, value, type);
  }

  /**
   * Creates an immutable copy of a {@link Token} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Token instance
   */
  public static ImmutableToken copyOf(Token instance) {
    if (instance instanceof ImmutableToken) {
      return (ImmutableToken) instance;
    }
    return ImmutableToken.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToken ImmutableToken}.
   * <pre>
   * ImmutableToken.builder()
   *    .start(int) // required {@link Token#start() start}
   *    .value(String) // required {@link Token#value() value}
   *    .type(de.flapdoodle.eval.core.parser.TokenType) // required {@link Token#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableToken builder
   */
  public static ImmutableToken.Builder builder() {
    return new ImmutableToken.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableToken ImmutableToken}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Token", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_START = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private int start;
    private String value;
    private TokenType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Token} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Token instance) {
      Objects.requireNonNull(instance, "instance");
      this.start(instance.start());
      this.value(instance.value());
      this.type(instance.type());
      return this;
    }

    /**
     * Initializes the value for the {@link Token#start() start} attribute.
     * @param start The value for start 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder start(int start) {
      this.start = start;
      initBits &= ~INIT_BIT_START;
      return this;
    }

    /**
     * Initializes the value for the {@link Token#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link Token#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(TokenType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableToken ImmutableToken}.
     * @return An immutable instance of Token
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToken build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableToken(null, start, value, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_START) != 0) attributes.add("start");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Token, some of required attributes are not set " + attributes;
    }
  }
}
