package de.flapdoodle.eval.core;

import de.flapdoodle.reflection.TypeInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MapBasedVariableTypeResolver}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMapBasedVariableTypeResolver.builder()}.
 */
@Generated(from = "MapBasedVariableTypeResolver", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMapBasedVariableTypeResolver
    extends MapBasedVariableTypeResolver {
  private final Map<String, TypeInfo<?>> variables;

  private ImmutableMapBasedVariableTypeResolver(Map<String, TypeInfo<?>> variables) {
    this.variables = variables;
  }

  /**
   * @return The value of the {@code variables} attribute
   */
  @Override
  protected Map<String, TypeInfo<?>> variables() {
    return variables;
  }

  /**
   * Copy the current immutable object by replacing the {@link MapBasedVariableTypeResolver#variables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMapBasedVariableTypeResolver withVariables(Map<String, ? extends TypeInfo<?>> entries) {
    if (this.variables == entries) return this;
    Map<String, TypeInfo<?>> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMapBasedVariableTypeResolver(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMapBasedVariableTypeResolver} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMapBasedVariableTypeResolver
        && equalTo(0, (ImmutableMapBasedVariableTypeResolver) another);
  }

  private boolean equalTo(int synthetic, ImmutableMapBasedVariableTypeResolver another) {
    return variables.equals(another.variables);
  }

  /**
   * Computes a hash code from attributes: {@code variables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MapBasedVariableTypeResolver} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapBasedVariableTypeResolver{"
        + "variables=" + variables
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MapBasedVariableTypeResolver} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MapBasedVariableTypeResolver instance
   */
  public static ImmutableMapBasedVariableTypeResolver copyOf(MapBasedVariableTypeResolver instance) {
    if (instance instanceof ImmutableMapBasedVariableTypeResolver) {
      return (ImmutableMapBasedVariableTypeResolver) instance;
    }
    return ImmutableMapBasedVariableTypeResolver.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMapBasedVariableTypeResolver ImmutableMapBasedVariableTypeResolver}.
   * <pre>
   * ImmutableMapBasedVariableTypeResolver.builder()
   *    .putVariables|putAllVariables(String =&gt; de.flapdoodle.reflection.TypeInfo&amp;lt;?&amp;gt;) // {@link MapBasedVariableTypeResolver#variables() variables} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableMapBasedVariableTypeResolver builder
   */
  public static ImmutableMapBasedVariableTypeResolver.Builder builder() {
    return new ImmutableMapBasedVariableTypeResolver.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMapBasedVariableTypeResolver ImmutableMapBasedVariableTypeResolver}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MapBasedVariableTypeResolver", generator = "Immutables")
  public static final class Builder {
    private Map<String, TypeInfo<?>> variables = new LinkedHashMap<String, TypeInfo<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapBasedVariableTypeResolver} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MapBasedVariableTypeResolver instance) {
      Objects.requireNonNull(instance, "instance");
      putAllVariables(instance.variables());
      return this;
    }

    /**
     * Put one entry to the {@link MapBasedVariableTypeResolver#variables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(String key, TypeInfo<?> value) {
      this.variables.put(
          Objects.requireNonNull(key, "variables key"),
          Objects.requireNonNull(value, value == null ? "variables value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link MapBasedVariableTypeResolver#variables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariables(Map.Entry<String, ? extends TypeInfo<?>> entry) {
      String k = entry.getKey();
      TypeInfo<?> v = entry.getValue();
      this.variables.put(
          Objects.requireNonNull(k, "variables key"),
          Objects.requireNonNull(v, v == null ? "variables value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MapBasedVariableTypeResolver#variables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder variables(Map<String, ? extends TypeInfo<?>> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MapBasedVariableTypeResolver#variables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends TypeInfo<?>> entries) {
      for (Map.Entry<String, ? extends TypeInfo<?>> e : entries.entrySet()) {
        String k = e.getKey();
        TypeInfo<?> v = e.getValue();
        this.variables.put(
            Objects.requireNonNull(k, "variables key"),
            Objects.requireNonNull(v, v == null ? "variables value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMapBasedVariableTypeResolver ImmutableMapBasedVariableTypeResolver}.
     * @return An immutable instance of MapBasedVariableTypeResolver
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMapBasedVariableTypeResolver build() {
      return new ImmutableMapBasedVariableTypeResolver(createUnmodifiableMap(false, false, variables));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
