package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.validation.ParameterValidator;
import de.flapdoodle.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Parameter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParameter.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableParameter.of()}.
 */
@Generated(from = "Parameter", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableParameter<T> implements Parameter<T> {
  private final TypeInfo<T> type;
  private final boolean isNullable;
  private final boolean isLazy;
  private final List<ParameterValidator<T>> validators;

  private ImmutableParameter(TypeInfo<T> type) {
    this.type = Objects.requireNonNull(type, "type");
    this.validators = Collections.emptyList();
    this.isNullable = initShim.isNullable();
    this.isLazy = initShim.isLazy();
    this.initShim = null;
  }

  private ImmutableParameter(ImmutableParameter.Builder<T> builder) {
    this.type = builder.type;
    this.validators = createUnmodifiableList(true, builder.validators);
    if (builder.isNullableIsSet()) {
      initShim.isNullable(builder.isNullable);
    }
    if (builder.isLazyIsSet()) {
      initShim.isLazy(builder.isLazy);
    }
    this.isNullable = initShim.isNullable();
    this.isLazy = initShim.isLazy();
    this.initShim = null;
  }

  private ImmutableParameter(
      TypeInfo<T> type,
      boolean isNullable,
      boolean isLazy,
      List<ParameterValidator<T>> validators) {
    this.type = type;
    this.isNullable = isNullable;
    this.isLazy = isLazy;
    this.validators = validators;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Parameter", generator = "Immutables")
  private final class InitShim {
    private byte isNullableBuildStage = STAGE_UNINITIALIZED;
    private boolean isNullable;

    boolean isNullable() {
      if (isNullableBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isNullableBuildStage == STAGE_UNINITIALIZED) {
        isNullableBuildStage = STAGE_INITIALIZING;
        this.isNullable = isNullableInitialize();
        isNullableBuildStage = STAGE_INITIALIZED;
      }
      return this.isNullable;
    }

    void isNullable(boolean isNullable) {
      this.isNullable = isNullable;
      isNullableBuildStage = STAGE_INITIALIZED;
    }

    private byte isLazyBuildStage = STAGE_UNINITIALIZED;
    private boolean isLazy;

    boolean isLazy() {
      if (isLazyBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isLazyBuildStage == STAGE_UNINITIALIZED) {
        isLazyBuildStage = STAGE_INITIALIZING;
        this.isLazy = isLazyInitialize();
        isLazyBuildStage = STAGE_INITIALIZED;
      }
      return this.isLazy;
    }

    void isLazy(boolean isLazy) {
      this.isLazy = isLazy;
      isLazyBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (isNullableBuildStage == STAGE_INITIALIZING) attributes.add("isNullable");
      if (isLazyBuildStage == STAGE_INITIALIZING) attributes.add("isLazy");
      return "Cannot build Parameter, attribute initializers form cycle " + attributes;
    }
  }

  private boolean isNullableInitialize() {
    return Parameter.super.isNullable();
  }

  private boolean isLazyInitialize() {
    return Parameter.super.isLazy();
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeInfo<T> type() {
    return type;
  }

  /**
   * @return The value of the {@code isNullable} attribute
   */
  @Override
  public boolean isNullable() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNullable()
        : this.isNullable;
  }

  /**
   * Set to true, the parameter will not be evaluated in advance, but the corresponding {@link
   * ASTNode} will be passed as a parameter value.
   */
  @Override
  public boolean isLazy() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isLazy()
        : this.isLazy;
  }

  /**
   * @return The value of the {@code validators} attribute
   */
  @Override
  public List<ParameterValidator<T>> validators() {
    return validators;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withType(TypeInfo<T> value) {
    if (this.type == value) return this;
    TypeInfo<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableParameter<>(newValue, this.isNullable, this.isLazy, this.validators);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#isNullable() isNullable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isNullable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withIsNullable(boolean value) {
    if (this.isNullable == value) return this;
    return new ImmutableParameter<>(this.type, value, this.isLazy, this.validators);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Parameter#isLazy() isLazy} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isLazy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParameter<T> withIsLazy(boolean value) {
    if (this.isLazy == value) return this;
    return new ImmutableParameter<>(this.type, this.isNullable, value, this.validators);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Parameter#validators() validators}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableParameter<T> withValidators(ParameterValidator<T>... elements) {
    List<ParameterValidator<T>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableParameter<>(this.type, this.isNullable, this.isLazy, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Parameter#validators() validators}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of validators elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParameter<T> withValidators(Iterable<? extends ParameterValidator<T>> elements) {
    if (this.validators == elements) return this;
    List<ParameterValidator<T>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableParameter<>(this.type, this.isNullable, this.isLazy, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParameter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParameter<?>
        && equalTo(0, (ImmutableParameter<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableParameter<?> another) {
    return type.equals(another.type)
        && isNullable == another.isNullable
        && isLazy == another.isLazy
        && validators.equals(another.validators);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code isNullable}, {@code isLazy}, {@code validators}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Boolean.hashCode(isNullable);
    h += (h << 5) + Boolean.hashCode(isLazy);
    h += (h << 5) + validators.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Parameter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Parameter{"
        + "type=" + type
        + ", isNullable=" + isNullable
        + ", isLazy=" + isLazy
        + ", validators=" + validators
        + "}";
  }

  /**
   * Construct a new immutable {@code Parameter} instance.
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @return An immutable Parameter instance
   */
  public static <T> ImmutableParameter<T> of(TypeInfo<T> type) {
    return new ImmutableParameter<>(type);
  }

  /**
   * Creates an immutable copy of a {@link Parameter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Parameter instance
   */
  public static <T> ImmutableParameter<T> copyOf(Parameter<T> instance) {
    if (instance instanceof ImmutableParameter<?>) {
      return (ImmutableParameter<T>) instance;
    }
    return ImmutableParameter.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParameter ImmutableParameter}.
   * <pre>
   * ImmutableParameter.&amp;lt;T&amp;gt;builder()
   *    .type(de.flapdoodle.reflection.TypeInfo&amp;lt;T&amp;gt;) // required {@link Parameter#type() type}
   *    .isNullable(boolean) // optional {@link Parameter#isNullable() isNullable}
   *    .isLazy(boolean) // optional {@link Parameter#isLazy() isLazy}
   *    .addValidators|addAllValidators(de.flapdoodle.eval.core.validation.ParameterValidator&amp;lt;T&amp;gt;) // {@link Parameter#validators() validators} elements
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableParameter builder
   */
  public static <T> ImmutableParameter.Builder<T> builder() {
    return new ImmutableParameter.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableParameter ImmutableParameter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Parameter", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long OPT_BIT_IS_NULLABLE = 0x1L;
    private static final long OPT_BIT_IS_LAZY = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private TypeInfo<T> type;
    private boolean isNullable;
    private boolean isLazy;
    private List<ParameterValidator<T>> validators = new ArrayList<ParameterValidator<T>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Parameter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Parameter<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.type());
      this.isNullable(instance.isNullable());
      this.isLazy(instance.isLazy());
      addAllValidators(instance.validators());
      return this;
    }

    /**
     * Initializes the value for the {@link Parameter#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(TypeInfo<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Parameter#isNullable() isNullable} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameter#isNullable() isNullable}.</em>
     * @param isNullable The value for isNullable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> isNullable(boolean isNullable) {
      this.isNullable = isNullable;
      optBits |= OPT_BIT_IS_NULLABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Parameter#isLazy() isLazy} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Parameter#isLazy() isLazy}.</em>
     * @param isLazy The value for isLazy 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> isLazy(boolean isLazy) {
      this.isLazy = isLazy;
      optBits |= OPT_BIT_IS_LAZY;
      return this;
    }

    /**
     * Adds one element to {@link Parameter#validators() validators} list.
     * @param element A validators element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addValidators(ParameterValidator<T> element) {
      this.validators.add(Objects.requireNonNull(element, "validators element"));
      return this;
    }

    /**
     * Adds elements to {@link Parameter#validators() validators} list.
     * @param elements An array of validators elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<T> addValidators(ParameterValidator<T>... elements) {
      for (ParameterValidator<T> element : elements) {
        this.validators.add(Objects.requireNonNull(element, "validators element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Parameter#validators() validators} list.
     * @param elements An iterable of validators elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> validators(Iterable<? extends ParameterValidator<T>> elements) {
      this.validators.clear();
      return addAllValidators(elements);
    }

    /**
     * Adds elements to {@link Parameter#validators() validators} list.
     * @param elements An iterable of validators elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllValidators(Iterable<? extends ParameterValidator<T>> elements) {
      for (ParameterValidator<T> element : elements) {
        this.validators.add(Objects.requireNonNull(element, "validators element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableParameter ImmutableParameter}.
     * @return An immutable instance of Parameter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParameter<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableParameter<T>(this);
    }

    private boolean isNullableIsSet() {
      return (optBits & OPT_BIT_IS_NULLABLE) != 0;
    }

    private boolean isLazyIsSet() {
      return (optBits & OPT_BIT_IS_LAZY) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Parameter, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
