package de.flapdoodle.eval.core.evaluables;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TypedEvaluableMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTypedEvaluableMap.builder()}.
 */
@Generated(from = "TypedEvaluableMap", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTypedEvaluableMap extends TypedEvaluableMap {
  private final Map<String, TypedEvaluableByNumberOfArguments> map;

  private ImmutableTypedEvaluableMap(
      Map<String, TypedEvaluableByNumberOfArguments> map) {
    this.map = map;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  protected Map<String, TypedEvaluableByNumberOfArguments> map() {
    return map;
  }

  /**
   * Copy the current immutable object by replacing the {@link TypedEvaluableMap#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTypedEvaluableMap withMap(Map<String, ? extends TypedEvaluableByNumberOfArguments> entries) {
    if (this.map == entries) return this;
    Map<String, TypedEvaluableByNumberOfArguments> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableTypedEvaluableMap(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypedEvaluableMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypedEvaluableMap
        && equalTo(0, (ImmutableTypedEvaluableMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableTypedEvaluableMap another) {
    return map.equals(another.map);
  }

  /**
   * Computes a hash code from attributes: {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + map.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TypedEvaluableMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TypedEvaluableMap{"
        + "map=" + map
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TypedEvaluableMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TypedEvaluableMap instance
   */
  public static ImmutableTypedEvaluableMap copyOf(TypedEvaluableMap instance) {
    if (instance instanceof ImmutableTypedEvaluableMap) {
      return (ImmutableTypedEvaluableMap) instance;
    }
    return ImmutableTypedEvaluableMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTypedEvaluableMap ImmutableTypedEvaluableMap}.
   * <pre>
   * ImmutableTypedEvaluableMap.builder()
   *    .putMap|putAllMap(String =&gt; de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments) // {@link TypedEvaluableMap#map() map} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableTypedEvaluableMap builder
   */
  public static ImmutableTypedEvaluableMap.Builder builder() {
    return new ImmutableTypedEvaluableMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTypedEvaluableMap ImmutableTypedEvaluableMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TypedEvaluableMap", generator = "Immutables")
  public static final class Builder {
    private Map<String, TypedEvaluableByNumberOfArguments> map = new LinkedHashMap<String, TypedEvaluableByNumberOfArguments>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TypedEvaluableMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TypedEvaluableMap instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMap(instance.map());
      return this;
    }

    /**
     * Put one entry to the {@link TypedEvaluableMap#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMap(String key, TypedEvaluableByNumberOfArguments value) {
      this.map.put(
          Objects.requireNonNull(key, "map key"),
          Objects.requireNonNull(value, value == null ? "map value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link TypedEvaluableMap#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMap(Map.Entry<String, ? extends TypedEvaluableByNumberOfArguments> entry) {
      String k = entry.getKey();
      TypedEvaluableByNumberOfArguments v = entry.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, v == null ? "map value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TypedEvaluableMap#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder map(Map<String, ? extends TypedEvaluableByNumberOfArguments> entries) {
      this.map.clear();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TypedEvaluableMap#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMap(Map<String, ? extends TypedEvaluableByNumberOfArguments> entries) {
      for (Map.Entry<String, ? extends TypedEvaluableByNumberOfArguments> e : entries.entrySet()) {
        String k = e.getKey();
        TypedEvaluableByNumberOfArguments v = e.getValue();
        this.map.put(
            Objects.requireNonNull(k, "map key"),
            Objects.requireNonNull(v, v == null ? "map value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTypedEvaluableMap ImmutableTypedEvaluableMap}.
     * @return An immutable instance of TypedEvaluableMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypedEvaluableMap build() {
      return new ImmutableTypedEvaluableMap(createUnmodifiableMap(false, false, map));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
