package de.flapdoodle.eval.core.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ASTNode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableASTNode.builder()}.
 */
@Generated(from = "ASTNode", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableASTNode extends ASTNode {
  private final List<ASTNode> parameters;
  private final Token token;

  private ImmutableASTNode(
      List<ASTNode> parameters,
      Token token) {
    this.parameters = parameters;
    this.token = token;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public List<ASTNode> getParameters() {
    return parameters;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Token getToken() {
    return token;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ASTNode#getParameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableASTNode withParameters(ASTNode... elements) {
    List<ASTNode> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableASTNode(newValue, this.token);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ASTNode#getParameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableASTNode withParameters(Iterable<? extends ASTNode> elements) {
    if (this.parameters == elements) return this;
    List<ASTNode> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableASTNode(newValue, this.token);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ASTNode#getToken() token} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableASTNode withToken(Token value) {
    if (this.token == value) return this;
    Token newValue = Objects.requireNonNull(value, "token");
    return new ImmutableASTNode(this.parameters, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableASTNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableASTNode
        && equalTo(0, (ImmutableASTNode) another);
  }

  private boolean equalTo(int synthetic, ImmutableASTNode another) {
    return parameters.equals(another.parameters)
        && token.equals(another.token);
  }

  /**
   * Computes a hash code from attributes: {@code parameters}, {@code token}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + parameters.hashCode();
    h += (h << 5) + token.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ASTNode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ASTNode{"
        + "parameters=" + parameters
        + ", token=" + token
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ASTNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ASTNode instance
   */
  public static ImmutableASTNode copyOf(ASTNode instance) {
    if (instance instanceof ImmutableASTNode) {
      return (ImmutableASTNode) instance;
    }
    return ImmutableASTNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableASTNode ImmutableASTNode}.
   * <pre>
   * ImmutableASTNode.builder()
   *    .addParameters|addAllParameters(de.flapdoodle.eval.core.parser.ASTNode) // {@link ASTNode#getParameters() parameters} elements
   *    .token(de.flapdoodle.eval.core.parser.Token) // required {@link ASTNode#getToken() token}
   *    .build();
   * </pre>
   * @return A new ImmutableASTNode builder
   */
  public static ImmutableASTNode.Builder builder() {
    return new ImmutableASTNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableASTNode ImmutableASTNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ASTNode", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private long initBits = 0x1L;

    private List<ASTNode> parameters = new ArrayList<ASTNode>();
    private Token token;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ASTNode} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ASTNode instance) {
      Objects.requireNonNull(instance, "instance");
      addAllParameters(instance.getParameters());
      this.token(instance.getToken());
      return this;
    }

    /**
     * Adds one element to {@link ASTNode#getParameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParameters(ASTNode element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      return this;
    }

    /**
     * Adds elements to {@link ASTNode#getParameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParameters(ASTNode... elements) {
      for (ASTNode element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ASTNode#getParameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(Iterable<? extends ASTNode> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link ASTNode#getParameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllParameters(Iterable<? extends ASTNode> elements) {
      for (ASTNode element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ASTNode#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Token token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Builds a new {@link ImmutableASTNode ImmutableASTNode}.
     * @return An immutable instance of ASTNode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableASTNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableASTNode(createUnmodifiableList(true, parameters), token);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      return "Cannot build ASTNode, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
