package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments;
import de.flapdoodle.eval.core.parser.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EvaluatableNode}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvaluatableNode.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEvaluatableNode.of()}.
 */
@Generated(from = "EvaluatableNode", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEvaluatableNode extends EvaluatableNode {
  private final Token token;
  private final TypedEvaluableByArguments evaluatable;
  private final List<Node> parameters;
  private final EvaluableExceptionMapper exceptionMapper;

  private ImmutableEvaluatableNode(
      Token token,
      TypedEvaluableByArguments evaluatable,
      Iterable<? extends Node> parameters,
      EvaluableExceptionMapper exceptionMapper) {
    this.token = Objects.requireNonNull(token, "token");
    this.evaluatable = Objects.requireNonNull(evaluatable, "evaluatable");
    this.parameters = createUnmodifiableList(false, createSafeList(parameters, true, false));
    this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper");
  }

  private ImmutableEvaluatableNode(
      ImmutableEvaluatableNode original,
      Token token,
      TypedEvaluableByArguments evaluatable,
      List<Node> parameters,
      EvaluableExceptionMapper exceptionMapper) {
    this.token = token;
    this.evaluatable = evaluatable;
    this.parameters = parameters;
    this.exceptionMapper = exceptionMapper;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Token token() {
    return token;
  }

  /**
   * @return The value of the {@code evaluatable} attribute
   */
  @Override
  protected TypedEvaluableByArguments evaluatable() {
    return evaluatable;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  protected List<Node> parameters() {
    return parameters;
  }

  /**
   * @return The value of the {@code exceptionMapper} attribute
   */
  @Override
  protected EvaluableExceptionMapper exceptionMapper() {
    return exceptionMapper;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatableNode#token() token} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatableNode withToken(Token value) {
    if (this.token == value) return this;
    Token newValue = Objects.requireNonNull(value, "token");
    return new ImmutableEvaluatableNode(this, newValue, this.evaluatable, this.parameters, this.exceptionMapper);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatableNode#evaluatable() evaluatable} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for evaluatable
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatableNode withEvaluatable(TypedEvaluableByArguments value) {
    if (this.evaluatable == value) return this;
    TypedEvaluableByArguments newValue = Objects.requireNonNull(value, "evaluatable");
    return new ImmutableEvaluatableNode(this, this.token, newValue, this.parameters, this.exceptionMapper);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EvaluatableNode#parameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvaluatableNode withParameters(Node... elements) {
    List<Node> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableEvaluatableNode(this, this.token, this.evaluatable, newValue, this.exceptionMapper);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link EvaluatableNode#parameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableEvaluatableNode withParameters(Iterable<? extends Node> elements) {
    if (this.parameters == elements) return this;
    List<Node> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableEvaluatableNode(this, this.token, this.evaluatable, newValue, this.exceptionMapper);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatableNode#exceptionMapper() exceptionMapper} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exceptionMapper
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatableNode withExceptionMapper(EvaluableExceptionMapper value) {
    if (this.exceptionMapper == value) return this;
    EvaluableExceptionMapper newValue = Objects.requireNonNull(value, "exceptionMapper");
    return new ImmutableEvaluatableNode(this, this.token, this.evaluatable, this.parameters, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvaluatableNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvaluatableNode
        && equalTo(0, (ImmutableEvaluatableNode) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvaluatableNode another) {
    return token.equals(another.token)
        && evaluatable.equals(another.evaluatable)
        && parameters.equals(another.parameters)
        && exceptionMapper.equals(another.exceptionMapper);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code evaluatable}, {@code parameters}, {@code exceptionMapper}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + token.hashCode();
    h += (h << 5) + evaluatable.hashCode();
    h += (h << 5) + parameters.hashCode();
    h += (h << 5) + exceptionMapper.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EvaluatableNode} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EvaluatableNode{"
        + "token=" + token
        + ", evaluatable=" + evaluatable
        + ", parameters=" + parameters
        + ", exceptionMapper=" + exceptionMapper
        + "}";
  }

  /**
   * Construct a new immutable {@code EvaluatableNode} instance.
   * @param token The value for the {@code token} attribute
   * @param evaluatable The value for the {@code evaluatable} attribute
   * @param parameters The value for the {@code parameters} attribute
   * @param exceptionMapper The value for the {@code exceptionMapper} attribute
   * @return An immutable EvaluatableNode instance
   */
  public static ImmutableEvaluatableNode of(Token token, TypedEvaluableByArguments evaluatable, List<Node> parameters, EvaluableExceptionMapper exceptionMapper) {
    return of(token, evaluatable, (Iterable<? extends Node>) parameters, exceptionMapper);
  }

  /**
   * Construct a new immutable {@code EvaluatableNode} instance.
   * @param token The value for the {@code token} attribute
   * @param evaluatable The value for the {@code evaluatable} attribute
   * @param parameters The value for the {@code parameters} attribute
   * @param exceptionMapper The value for the {@code exceptionMapper} attribute
   * @return An immutable EvaluatableNode instance
   */
  public static ImmutableEvaluatableNode of(Token token, TypedEvaluableByArguments evaluatable, Iterable<? extends Node> parameters, EvaluableExceptionMapper exceptionMapper) {
    return new ImmutableEvaluatableNode(token, evaluatable, parameters, exceptionMapper);
  }

  /**
   * Creates an immutable copy of a {@link EvaluatableNode} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EvaluatableNode instance
   */
  public static ImmutableEvaluatableNode copyOf(EvaluatableNode instance) {
    if (instance instanceof ImmutableEvaluatableNode) {
      return (ImmutableEvaluatableNode) instance;
    }
    return ImmutableEvaluatableNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvaluatableNode ImmutableEvaluatableNode}.
   * <pre>
   * ImmutableEvaluatableNode.builder()
   *    .token(de.flapdoodle.eval.core.parser.Token) // required {@link EvaluatableNode#token() token}
   *    .evaluatable(de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments) // required {@link EvaluatableNode#evaluatable() evaluatable}
   *    .addParameters|addAllParameters(de.flapdoodle.eval.core.tree.Node) // {@link EvaluatableNode#parameters() parameters} elements
   *    .exceptionMapper(de.flapdoodle.eval.core.tree.EvaluableExceptionMapper) // required {@link EvaluatableNode#exceptionMapper() exceptionMapper}
   *    .build();
   * </pre>
   * @return A new ImmutableEvaluatableNode builder
   */
  public static ImmutableEvaluatableNode.Builder builder() {
    return new ImmutableEvaluatableNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvaluatableNode ImmutableEvaluatableNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EvaluatableNode", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_EVALUATABLE = 0x2L;
    private static final long INIT_BIT_EXCEPTION_MAPPER = 0x4L;
    private long initBits = 0x7L;

    private Token token;
    private TypedEvaluableByArguments evaluatable;
    private List<Node> parameters = new ArrayList<Node>();
    private EvaluableExceptionMapper exceptionMapper;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.eval.core.tree.EvaluatableNode} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EvaluatableNode instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code de.flapdoodle.eval.core.tree.Node} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Node instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof EvaluatableNode) {
        EvaluatableNode instance = (EvaluatableNode) object;
        this.exceptionMapper(instance.exceptionMapper());
        addAllParameters(instance.parameters());
        this.evaluatable(instance.evaluatable());
      }
      if (object instanceof Node) {
        Node instance = (Node) object;
        this.token(instance.token());
      }
    }

    /**
     * Initializes the value for the {@link EvaluatableNode#token() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder token(Token token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatableNode#evaluatable() evaluatable} attribute.
     * @param evaluatable The value for evaluatable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder evaluatable(TypedEvaluableByArguments evaluatable) {
      this.evaluatable = Objects.requireNonNull(evaluatable, "evaluatable");
      initBits &= ~INIT_BIT_EVALUATABLE;
      return this;
    }

    /**
     * Adds one element to {@link EvaluatableNode#parameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParameters(Node element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      return this;
    }

    /**
     * Adds elements to {@link EvaluatableNode#parameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParameters(Node... elements) {
      for (Node element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link EvaluatableNode#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder parameters(Iterable<? extends Node> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link EvaluatableNode#parameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllParameters(Iterable<? extends Node> elements) {
      for (Node element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatableNode#exceptionMapper() exceptionMapper} attribute.
     * @param exceptionMapper The value for exceptionMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exceptionMapper(EvaluableExceptionMapper exceptionMapper) {
      this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper");
      initBits &= ~INIT_BIT_EXCEPTION_MAPPER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvaluatableNode ImmutableEvaluatableNode}.
     * @return An immutable instance of EvaluatableNode
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvaluatableNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEvaluatableNode(null, token, evaluatable, createUnmodifiableList(true, parameters), exceptionMapper);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      if ((initBits & INIT_BIT_EVALUATABLE) != 0) attributes.add("evaluatable");
      if ((initBits & INIT_BIT_EXCEPTION_MAPPER) != 0) attributes.add("exceptionMapper");
      return "Cannot build EvaluatableNode, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
