package de.flapdoodle.eval.core.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Variable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableVariable.of()}.
 */
@Generated(from = "Variable", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableVariable extends Variable {
  private final int hash;
  private final String name;
  private final int position;

  private ImmutableVariable(int hash, String name, int position) {
    this.hash = hash;
    this.name = Objects.requireNonNull(name, "name");
    this.position = position;
  }

  private ImmutableVariable(ImmutableVariable original, int hash, String name, int position) {
    this.hash = hash;
    this.name = name;
    this.position = position;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @Override
  public int hash() {
    return hash;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public int position() {
    return position;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#hash() hash} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withHash(int value) {
    if (this.hash == value) return this;
    return new ImmutableVariable(this, value, this.name, this.position);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableVariable(this, this.hash, newValue, this.position);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Variable#position() position} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for position
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariable withPosition(int value) {
    if (this.position == value) return this;
    return new ImmutableVariable(this, this.hash, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariable
        && equalTo(0, (ImmutableVariable) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariable another) {
    return hash == another.hash
        && name.equals(another.name)
        && position == another.position;
  }

  /**
   * Computes a hash code from attributes: {@code hash}, {@code name}, {@code position}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + hash;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + position;
    return h;
  }

  /**
   * Prints the immutable value {@code Variable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Variable{"
        + "hash=" + hash
        + ", name=" + name
        + ", position=" + position
        + "}";
  }

  /**
   * Construct a new immutable {@code Variable} instance.
   * @param hash The value for the {@code hash} attribute
   * @param name The value for the {@code name} attribute
   * @param position The value for the {@code position} attribute
   * @return An immutable Variable instance
   */
  public static ImmutableVariable of(int hash, String name, int position) {
    return new ImmutableVariable(hash, name, position);
  }

  /**
   * Creates an immutable copy of a {@link Variable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Variable instance
   */
  public static ImmutableVariable copyOf(Variable instance) {
    if (instance instanceof ImmutableVariable) {
      return (ImmutableVariable) instance;
    }
    return ImmutableVariable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariable ImmutableVariable}.
   * <pre>
   * ImmutableVariable.builder()
   *    .hash(int) // required {@link Variable#hash() hash}
   *    .name(String) // required {@link Variable#name() name}
   *    .position(int) // required {@link Variable#position() position}
   *    .build();
   * </pre>
   * @return A new ImmutableVariable builder
   */
  public static ImmutableVariable.Builder builder() {
    return new ImmutableVariable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariable ImmutableVariable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Variable", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_HASH = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_POSITION = 0x4L;
    private long initBits = 0x7L;

    private int hash;
    private String name;
    private int position;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Variable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Variable instance) {
      Objects.requireNonNull(instance, "instance");
      this.hash(instance.hash());
      this.name(instance.name());
      this.position(instance.position());
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#hash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder hash(int hash) {
      this.hash = hash;
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Variable#position() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(int position) {
      this.position = position;
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariable ImmutableVariable}.
     * @return An immutable instance of Variable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVariable(null, hash, name, position);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      return "Cannot build Variable, some of required attributes are not set " + attributes;
    }
  }
}
