package de.flapdoodle.eval.example;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueMap.builder()}.
 */
@Generated(from = "ValueMap", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableValueMap extends ValueMap {
  private final Map<String, Value<?>> values;

  private ImmutableValueMap(Map<String, Value<?>> values) {
    this.values = values;
  }

  /**
   * @return The value of the {@code values} attribute
   */
  @Override
  protected Map<String, Value<?>> values() {
    return values;
  }

  /**
   * Copy the current immutable object by replacing the {@link ValueMap#values() values} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the values map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValueMap withValues(Map<String, ? extends Value<?>> entries) {
    if (this.values == entries) return this;
    Map<String, Value<?>> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableValueMap(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValueMap
        && equalTo(0, (ImmutableValueMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableValueMap another) {
    return values.equals(another.values);
  }

  /**
   * Computes a hash code from attributes: {@code values}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + values.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ValueMap{"
        + "values=" + values
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ValueMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueMap instance
   */
  public static ImmutableValueMap copyOf(ValueMap instance) {
    if (instance instanceof ImmutableValueMap) {
      return (ImmutableValueMap) instance;
    }
    return ImmutableValueMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueMap ImmutableValueMap}.
   * <pre>
   * ImmutableValueMap.builder()
   *    .putValues|putAllValues(String =&gt; de.flapdoodle.eval.example.Value&amp;lt;?&amp;gt;) // {@link ValueMap#values() values} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableValueMap builder
   */
  public static ImmutableValueMap.Builder builder() {
    return new ImmutableValueMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueMap ImmutableValueMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueMap", generator = "Immutables")
  public static final class Builder {
    private Map<String, Value<?>> values = new LinkedHashMap<String, Value<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ValueMap instance) {
      Objects.requireNonNull(instance, "instance");
      putAllValues(instance.values());
      return this;
    }

    /**
     * Put one entry to the {@link ValueMap#values() values} map.
     * @param key The key in the values map
     * @param value The associated value in the values map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putValues(String key, Value<?> value) {
      this.values.put(
          Objects.requireNonNull(key, "values key"),
          Objects.requireNonNull(value, value == null ? "values value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link ValueMap#values() values} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putValues(Map.Entry<String, ? extends Value<?>> entry) {
      String k = entry.getKey();
      Value<?> v = entry.getValue();
      this.values.put(
          Objects.requireNonNull(k, "values key"),
          Objects.requireNonNull(v, v == null ? "values value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ValueMap#values() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder values(Map<String, ? extends Value<?>> entries) {
      this.values.clear();
      return putAllValues(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ValueMap#values() values} map. Nulls are not permitted
     * @param entries The entries that will be added to the values map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllValues(Map<String, ? extends Value<?>> entries) {
      for (Map.Entry<String, ? extends Value<?>> e : entries.entrySet()) {
        String k = e.getKey();
        Value<?> v = e.getValue();
        this.values.put(
            Objects.requireNonNull(k, "values key"),
            Objects.requireNonNull(v, v == null ? "values value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueMap ImmutableValueMap}.
     * @return An immutable instance of ValueMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueMap build() {
      return new ImmutableValueMap(createUnmodifiableMap(false, false, values));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
