/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.ExpressionFactory;
import de.flapdoodle.eval.core.NumberAsValue;
import de.flapdoodle.eval.core.StringAsValue;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.OperatorMap;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByName;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments;
import de.flapdoodle.eval.core.tree.EvaluableExceptionMapper;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ExpressionFactory", generator="Immutables")
public final class ImmutableExpressionFactory
extends ExpressionFactory {
    private final MathContext mathContext;
    private final ZoneId zoneId;
    private final VariableResolver constants;
    private final TypedEvaluableByName evaluatables;
    private final TypedEvaluableByNumberOfArguments arrayAccess;
    private final TypedEvaluableByNumberOfArguments propertyAccess;
    private final NumberAsValue numberAsValue;
    private final StringAsValue stringAsValue;
    private final EvaluableExceptionMapper exceptionMapper;
    private final OperatorMap operatorMap;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableExpressionFactory(Builder builder) {
        this.constants = builder.constants;
        this.evaluatables = builder.evaluatables;
        this.arrayAccess = builder.arrayAccess;
        this.propertyAccess = builder.propertyAccess;
        this.numberAsValue = builder.numberAsValue;
        this.stringAsValue = builder.stringAsValue;
        this.exceptionMapper = builder.exceptionMapper;
        this.operatorMap = builder.operatorMap;
        if (builder.mathContext != null) {
            this.initShim.mathContext(builder.mathContext);
        }
        if (builder.zoneId != null) {
            this.initShim.zoneId(builder.zoneId);
        }
        this.mathContext = this.initShim.mathContext();
        this.zoneId = this.initShim.zoneId();
        this.initShim = null;
    }

    private ImmutableExpressionFactory(MathContext mathContext, ZoneId zoneId, VariableResolver constants, TypedEvaluableByName evaluatables, TypedEvaluableByNumberOfArguments arrayAccess, TypedEvaluableByNumberOfArguments propertyAccess, NumberAsValue numberAsValue, StringAsValue stringAsValue, EvaluableExceptionMapper exceptionMapper, OperatorMap operatorMap) {
        this.mathContext = mathContext;
        this.zoneId = zoneId;
        this.constants = constants;
        this.evaluatables = evaluatables;
        this.arrayAccess = arrayAccess;
        this.propertyAccess = propertyAccess;
        this.numberAsValue = numberAsValue;
        this.stringAsValue = stringAsValue;
        this.exceptionMapper = exceptionMapper;
        this.operatorMap = operatorMap;
        this.initShim = null;
    }

    @Override
    public MathContext mathContext() {
        InitShim shim = this.initShim;
        return shim != null ? shim.mathContext() : this.mathContext;
    }

    @Override
    protected ZoneId zoneId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.zoneId() : this.zoneId;
    }

    @Override
    public VariableResolver constants() {
        return this.constants;
    }

    @Override
    public TypedEvaluableByName evaluatables() {
        return this.evaluatables;
    }

    @Override
    protected TypedEvaluableByNumberOfArguments arrayAccess() {
        return this.arrayAccess;
    }

    @Override
    protected TypedEvaluableByNumberOfArguments propertyAccess() {
        return this.propertyAccess;
    }

    @Override
    protected NumberAsValue numberAsValue() {
        return this.numberAsValue;
    }

    @Override
    protected StringAsValue stringAsValue() {
        return this.stringAsValue;
    }

    @Override
    protected EvaluableExceptionMapper exceptionMapper() {
        return this.exceptionMapper;
    }

    @Override
    public OperatorMap operatorMap() {
        return this.operatorMap;
    }

    public final ImmutableExpressionFactory withMathContext(MathContext value) {
        if (this.mathContext == value) {
            return this;
        }
        MathContext newValue = Objects.requireNonNull(value, "mathContext");
        return new ImmutableExpressionFactory(newValue, this.zoneId, this.constants, this.evaluatables, this.arrayAccess, this.propertyAccess, this.numberAsValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withZoneId(ZoneId value) {
        if (this.zoneId == value) {
            return this;
        }
        ZoneId newValue = Objects.requireNonNull(value, "zoneId");
        return new ImmutableExpressionFactory(this.mathContext, newValue, this.constants, this.evaluatables, this.arrayAccess, this.propertyAccess, this.numberAsValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withConstants(VariableResolver value) {
        if (this.constants == value) {
            return this;
        }
        VariableResolver newValue = Objects.requireNonNull(value, "constants");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, newValue, this.evaluatables, this.arrayAccess, this.propertyAccess, this.numberAsValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withEvaluatables(TypedEvaluableByName value) {
        if (this.evaluatables == value) {
            return this;
        }
        TypedEvaluableByName newValue = Objects.requireNonNull(value, "evaluatables");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, newValue, this.arrayAccess, this.propertyAccess, this.numberAsValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withArrayAccess(TypedEvaluableByNumberOfArguments value) {
        if (this.arrayAccess == value) {
            return this;
        }
        TypedEvaluableByNumberOfArguments newValue = Objects.requireNonNull(value, "arrayAccess");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, this.evaluatables, newValue, this.propertyAccess, this.numberAsValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withPropertyAccess(TypedEvaluableByNumberOfArguments value) {
        if (this.propertyAccess == value) {
            return this;
        }
        TypedEvaluableByNumberOfArguments newValue = Objects.requireNonNull(value, "propertyAccess");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, this.evaluatables, this.arrayAccess, newValue, this.numberAsValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withNumberAsValue(NumberAsValue value) {
        if (this.numberAsValue == value) {
            return this;
        }
        NumberAsValue newValue = Objects.requireNonNull(value, "numberAsValue");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, this.evaluatables, this.arrayAccess, this.propertyAccess, newValue, this.stringAsValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withStringAsValue(StringAsValue value) {
        if (this.stringAsValue == value) {
            return this;
        }
        StringAsValue newValue = Objects.requireNonNull(value, "stringAsValue");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, this.evaluatables, this.arrayAccess, this.propertyAccess, this.numberAsValue, newValue, this.exceptionMapper, this.operatorMap);
    }

    public final ImmutableExpressionFactory withExceptionMapper(EvaluableExceptionMapper value) {
        if (this.exceptionMapper == value) {
            return this;
        }
        EvaluableExceptionMapper newValue = Objects.requireNonNull(value, "exceptionMapper");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, this.evaluatables, this.arrayAccess, this.propertyAccess, this.numberAsValue, this.stringAsValue, newValue, this.operatorMap);
    }

    public final ImmutableExpressionFactory withOperatorMap(OperatorMap value) {
        if (this.operatorMap == value) {
            return this;
        }
        OperatorMap newValue = Objects.requireNonNull(value, "operatorMap");
        return new ImmutableExpressionFactory(this.mathContext, this.zoneId, this.constants, this.evaluatables, this.arrayAccess, this.propertyAccess, this.numberAsValue, this.stringAsValue, this.exceptionMapper, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpressionFactory && this.equalTo(0, (ImmutableExpressionFactory)another);
    }

    private boolean equalTo(int synthetic, ImmutableExpressionFactory another) {
        return this.mathContext.equals(another.mathContext) && this.zoneId.equals(another.zoneId) && this.constants.equals(another.constants) && this.evaluatables.equals(another.evaluatables) && this.arrayAccess.equals(another.arrayAccess) && this.propertyAccess.equals(another.propertyAccess) && this.numberAsValue.equals(another.numberAsValue) && this.stringAsValue.equals(another.stringAsValue) && this.exceptionMapper.equals(another.exceptionMapper) && this.operatorMap.equals(another.operatorMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mathContext.hashCode();
        h += (h << 5) + this.zoneId.hashCode();
        h += (h << 5) + this.constants.hashCode();
        h += (h << 5) + this.evaluatables.hashCode();
        h += (h << 5) + this.arrayAccess.hashCode();
        h += (h << 5) + this.propertyAccess.hashCode();
        h += (h << 5) + this.numberAsValue.hashCode();
        h += (h << 5) + this.stringAsValue.hashCode();
        h += (h << 5) + this.exceptionMapper.hashCode();
        h += (h << 5) + this.operatorMap.hashCode();
        return h;
    }

    public String toString() {
        return "ExpressionFactory{mathContext=" + this.mathContext + ", zoneId=" + this.zoneId + ", constants=" + this.constants + ", evaluatables=" + this.evaluatables + ", arrayAccess=" + this.arrayAccess + ", propertyAccess=" + this.propertyAccess + ", numberAsValue=" + this.numberAsValue + ", stringAsValue=" + this.stringAsValue + ", exceptionMapper=" + this.exceptionMapper + ", operatorMap=" + this.operatorMap + "}";
    }

    public static ImmutableExpressionFactory copyOf(ExpressionFactory instance) {
        if (instance instanceof ImmutableExpressionFactory) {
            return (ImmutableExpressionFactory)instance;
        }
        return ImmutableExpressionFactory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExpressionFactory", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONSTANTS = 1L;
        private static final long INIT_BIT_EVALUATABLES = 2L;
        private static final long INIT_BIT_ARRAY_ACCESS = 4L;
        private static final long INIT_BIT_PROPERTY_ACCESS = 8L;
        private static final long INIT_BIT_NUMBER_AS_VALUE = 16L;
        private static final long INIT_BIT_STRING_AS_VALUE = 32L;
        private static final long INIT_BIT_EXCEPTION_MAPPER = 64L;
        private static final long INIT_BIT_OPERATOR_MAP = 128L;
        private long initBits = 255L;
        private MathContext mathContext;
        private ZoneId zoneId;
        private VariableResolver constants;
        private TypedEvaluableByName evaluatables;
        private TypedEvaluableByNumberOfArguments arrayAccess;
        private TypedEvaluableByNumberOfArguments propertyAccess;
        private NumberAsValue numberAsValue;
        private StringAsValue stringAsValue;
        private EvaluableExceptionMapper exceptionMapper;
        private OperatorMap operatorMap;

        private Builder() {
        }

        public final Builder from(ExpressionFactory instance) {
            Objects.requireNonNull(instance, "instance");
            this.mathContext(instance.mathContext());
            this.zoneId(instance.zoneId());
            this.constants(instance.constants());
            this.evaluatables(instance.evaluatables());
            this.arrayAccess(instance.arrayAccess());
            this.propertyAccess(instance.propertyAccess());
            this.numberAsValue(instance.numberAsValue());
            this.stringAsValue(instance.stringAsValue());
            this.exceptionMapper(instance.exceptionMapper());
            this.operatorMap(instance.operatorMap());
            return this;
        }

        public final Builder mathContext(MathContext mathContext) {
            this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
            return this;
        }

        public final Builder zoneId(ZoneId zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
            return this;
        }

        public final Builder constants(VariableResolver constants) {
            this.constants = Objects.requireNonNull(constants, "constants");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder evaluatables(TypedEvaluableByName evaluatables) {
            this.evaluatables = Objects.requireNonNull(evaluatables, "evaluatables");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder arrayAccess(TypedEvaluableByNumberOfArguments arrayAccess) {
            this.arrayAccess = Objects.requireNonNull(arrayAccess, "arrayAccess");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder propertyAccess(TypedEvaluableByNumberOfArguments propertyAccess) {
            this.propertyAccess = Objects.requireNonNull(propertyAccess, "propertyAccess");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder numberAsValue(NumberAsValue numberAsValue) {
            this.numberAsValue = Objects.requireNonNull(numberAsValue, "numberAsValue");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder stringAsValue(StringAsValue stringAsValue) {
            this.stringAsValue = Objects.requireNonNull(stringAsValue, "stringAsValue");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder exceptionMapper(EvaluableExceptionMapper exceptionMapper) {
            this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder operatorMap(OperatorMap operatorMap) {
            this.operatorMap = Objects.requireNonNull(operatorMap, "operatorMap");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableExpressionFactory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpressionFactory(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constants");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("evaluatables");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arrayAccess");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("propertyAccess");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("numberAsValue");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("stringAsValue");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("exceptionMapper");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("operatorMap");
            }
            return "Cannot build ExpressionFactory, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ExpressionFactory", generator="Immutables")
    private final class InitShim {
        private byte mathContextBuildStage = 0;
        private MathContext mathContext;
        private byte zoneIdBuildStage = 0;
        private ZoneId zoneId;

        private InitShim() {
        }

        MathContext mathContext() {
            if (this.mathContextBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.mathContextBuildStage == 0) {
                this.mathContextBuildStage = (byte)-1;
                this.mathContext = Objects.requireNonNull(ImmutableExpressionFactory.super.mathContext(), "mathContext");
                this.mathContextBuildStage = 1;
            }
            return this.mathContext;
        }

        void mathContext(MathContext mathContext) {
            this.mathContext = mathContext;
            this.mathContextBuildStage = 1;
        }

        ZoneId zoneId() {
            if (this.zoneIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.zoneIdBuildStage == 0) {
                this.zoneIdBuildStage = (byte)-1;
                this.zoneId = Objects.requireNonNull(ImmutableExpressionFactory.super.zoneId(), "zoneId");
                this.zoneIdBuildStage = 1;
            }
            return this.zoneId;
        }

        void zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            this.zoneIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.mathContextBuildStage == -1) {
                attributes.add("mathContext");
            }
            if (this.zoneIdBuildStage == -1) {
                attributes.add("zoneId");
            }
            return "Cannot build ExpressionFactory, attribute initializers form cycle " + attributes;
        }
    }
}

