/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.ImmutableMapBasedVariableTypeResolver;
import de.flapdoodle.eval.core.VariableTypeResolver;
import de.flapdoodle.reflection.TypeInfo;
import java.util.Map;
import org.immutables.value.Value;

@Value.Immutable
public abstract class MapBasedVariableTypeResolver
implements VariableTypeResolver {
    protected abstract Map<String, TypeInfo<?>> variables();

    @Override
    @Value.Auxiliary
    public TypeInfo<?> get(String variable) {
        return this.variables().get(variable);
    }

    @Value.Auxiliary
    public ImmutableMapBasedVariableTypeResolver with(String variable, TypeInfo<?> value) {
        return MapBasedVariableTypeResolver.builder().from(this).putVariables(variable, value).build();
    }

    @Value.Auxiliary
    public ImmutableMapBasedVariableTypeResolver and(String variable, TypeInfo<?> value) {
        return this.with(variable, value);
    }

    @Value.Auxiliary
    public ImmutableMapBasedVariableTypeResolver withValues(Map<String, ? extends TypeInfo<?>> values) {
        ImmutableMapBasedVariableTypeResolver.Builder builder = MapBasedVariableTypeResolver.builder().from(this);
        for (Map.Entry<String, TypeInfo<?>> entry : values.entrySet()) {
            builder.putVariables(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static ImmutableMapBasedVariableTypeResolver.Builder builder() {
        return ImmutableMapBasedVariableTypeResolver.builder();
    }

    public static ImmutableMapBasedVariableTypeResolver empty() {
        return MapBasedVariableTypeResolver.builder().build();
    }
}

