/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.Nullable;
import de.flapdoodle.eval.core.evaluables.ImmutableEvaluated;
import de.flapdoodle.reflection.TypeInfo;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Evaluated<T> {
    @Value.Parameter
    public abstract TypeInfo<T> type();

    @Nullable
    @Value.Parameter
    public abstract T wrapped();

    @Value.Derived
    public boolean isNull() {
        return this.wrapped() == null;
    }

    public static <T> Evaluated<T> value(T value) {
        return Evaluated.ofNullable(TypeInfo.of(value.getClass()), value);
    }

    public static <T> Evaluated<T> ofNullable(Class<T> type, @Nullable T value) {
        return Evaluated.ofNullable(TypeInfo.of(type), value);
    }

    public static <T> Evaluated<T> ofNull(Class<T> type) {
        return Evaluated.ofNullable(TypeInfo.of(type), null);
    }

    public static <T> Evaluated<T> ofNull(TypeInfo<T> type) {
        return Evaluated.ofNullable(type, null);
    }

    public static <T> Evaluated<T> ofNullable(TypeInfo<T> type, @Nullable T value) {
        return ImmutableEvaluated.of(type, value);
    }

    public static List<?> unwrap(List<? extends Evaluated<?>> src) {
        return src.stream().map(it -> it.wrapped()).collect(Collectors.toList());
    }

    public static <T> List<? extends Evaluated<T>> wrap(List<T> src) {
        return src.stream().map(it -> Evaluated.value(it)).collect(Collectors.toList());
    }

    public static <T> List<? extends Evaluated<T>> asList(T ... src) {
        return Evaluated.wrap(Arrays.asList(src));
    }
}

