/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.OperatorMapping;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="OperatorMapping", generator="Immutables")
public final class ImmutableOperatorMapping
implements OperatorMapping {
    private final int precedence;
    private final boolean isLeftAssociative;
    private final String evaluatable;

    private ImmutableOperatorMapping(int precedence, boolean isLeftAssociative, String evaluatable) {
        this.precedence = precedence;
        this.isLeftAssociative = isLeftAssociative;
        this.evaluatable = evaluatable;
    }

    @Override
    public int precedence() {
        return this.precedence;
    }

    @Override
    public boolean isLeftAssociative() {
        return this.isLeftAssociative;
    }

    @Override
    public String evaluatable() {
        return this.evaluatable;
    }

    public final ImmutableOperatorMapping withPrecedence(int value) {
        if (this.precedence == value) {
            return this;
        }
        return new ImmutableOperatorMapping(value, this.isLeftAssociative, this.evaluatable);
    }

    public final ImmutableOperatorMapping withIsLeftAssociative(boolean value) {
        if (this.isLeftAssociative == value) {
            return this;
        }
        return new ImmutableOperatorMapping(this.precedence, value, this.evaluatable);
    }

    public final ImmutableOperatorMapping withEvaluatable(String value) {
        String newValue = Objects.requireNonNull(value, "evaluatable");
        if (this.evaluatable.equals(newValue)) {
            return this;
        }
        return new ImmutableOperatorMapping(this.precedence, this.isLeftAssociative, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOperatorMapping && this.equalTo(0, (ImmutableOperatorMapping)another);
    }

    private boolean equalTo(int synthetic, ImmutableOperatorMapping another) {
        return this.precedence == another.precedence && this.isLeftAssociative == another.isLeftAssociative && this.evaluatable.equals(another.evaluatable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.precedence;
        h += (h << 5) + Boolean.hashCode(this.isLeftAssociative);
        h += (h << 5) + this.evaluatable.hashCode();
        return h;
    }

    public String toString() {
        return "OperatorMapping{precedence=" + this.precedence + ", isLeftAssociative=" + this.isLeftAssociative + ", evaluatable=" + this.evaluatable + "}";
    }

    public static ImmutableOperatorMapping copyOf(OperatorMapping instance) {
        if (instance instanceof ImmutableOperatorMapping) {
            return (ImmutableOperatorMapping)instance;
        }
        return ImmutableOperatorMapping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OperatorMapping", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PRECEDENCE = 1L;
        private static final long INIT_BIT_IS_LEFT_ASSOCIATIVE = 2L;
        private static final long INIT_BIT_EVALUATABLE = 4L;
        private long initBits = 7L;
        private int precedence;
        private boolean isLeftAssociative;
        private String evaluatable;

        private Builder() {
        }

        public final Builder from(OperatorMapping instance) {
            Objects.requireNonNull(instance, "instance");
            this.precedence(instance.precedence());
            this.isLeftAssociative(instance.isLeftAssociative());
            this.evaluatable(instance.evaluatable());
            return this;
        }

        public final Builder precedence(int precedence) {
            this.precedence = precedence;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder isLeftAssociative(boolean isLeftAssociative) {
            this.isLeftAssociative = isLeftAssociative;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder evaluatable(String evaluatable) {
            this.evaluatable = Objects.requireNonNull(evaluatable, "evaluatable");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableOperatorMapping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOperatorMapping(this.precedence, this.isLeftAssociative, this.evaluatable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("precedence");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isLeftAssociative");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("evaluatable");
            }
            return "Cannot build OperatorMapping, some of required attributes are not set " + attributes;
        }
    }
}

