/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.ImmutableParameter;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.validation.ParameterValidator;
import de.flapdoodle.reflection.TypeInfo;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public interface Parameter<T> {
    @Value.Parameter
    public TypeInfo<T> type();

    @Value.Default
    default public boolean isNullable() {
        return false;
    }

    @Value.Default
    default public boolean isLazy() {
        return false;
    }

    public List<ParameterValidator<T>> validators();

    public static <T> ImmutableParameter<T> of(Class<T> type) {
        return ImmutableParameter.of(TypeInfo.of(type));
    }

    public static <T> ImmutableParameter<T> of(TypeInfo<T> type) {
        return ImmutableParameter.of(type);
    }

    public static <T> ImmutableParameter<T> lazyWith(Class<T> type) {
        return Parameter.lazyWith(TypeInfo.of(type));
    }

    public static <T> ImmutableParameter<T> lazyWith(TypeInfo<T> type) {
        return ImmutableParameter.of(type).withIsLazy(true);
    }

    public static <T> ImmutableParameter<T> nullableWith(Class<T> type) {
        return Parameter.nullableWith(TypeInfo.of(type));
    }

    public static <T> ImmutableParameter<T> nullableWith(TypeInfo<T> type) {
        return ImmutableParameter.of(type).withIsNullable(true);
    }

    @Deprecated
    @Value.Auxiliary
    default public void validate(Token token, Evaluated<?> parameterValue) throws EvaluationException {
        Optional<EvaluableException> error = this.validationError(parameterValue);
        if (error.isPresent()) {
            throw new EvaluationException(token, error.get());
        }
    }

    @Value.Auxiliary
    default public Optional<EvaluableException> validationError(Evaluated<?> parameterValue) {
        if (this.isNullable() && parameterValue.isNull()) {
            return Optional.empty();
        }
        if (this.type().isInstance(parameterValue.wrapped())) {
            Object value = this.type().cast(parameterValue.wrapped());
            for (ParameterValidator<Object> parameterValidator : this.validators()) {
                Optional<EvaluableException> error = parameterValidator.validate(value);
                if (!error.isPresent()) continue;
                return error;
            }
        } else {
            return Optional.of(EvaluableException.ofUnsupportedDataTypeInOperation());
        }
        return Optional.empty();
    }
}

