/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.Evaluable;
import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.Signature;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import java.util.List;
import java.util.Optional;

class TypedEvaluableAdapter<T>
implements TypedEvaluable<T> {
    private final Signature<T> signature;
    private final Evaluable<T> delegate;

    public TypedEvaluableAdapter(Signature<T> signature, Evaluable<T> delegate) {
        this.signature = signature;
        this.delegate = delegate;
    }

    @Override
    public Signature<T> signature() {
        return this.signature;
    }

    @Override
    public Evaluated<T> evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, List<? extends Evaluated<?>> arguments) throws EvaluationException {
        this.checkArguments(token, arguments);
        return Evaluated.ofNullable(this.signature.returnType(), this.delegate.evaluate(variableResolver, evaluationContext, token, Evaluated.unwrap(arguments)));
    }

    protected void checkArguments(Token token, List<? extends Evaluated<?>> arguments) throws EvaluationException {
        Optional<EvaluableException> error = this.signature().validateArguments(arguments);
        if (error.isPresent()) {
            throw new EvaluationException(token, error.get());
        }
    }

    public String toString() {
        return "TypedEvaluableAdapter{signature=" + this.signature + ", delegate=" + this.delegate + '}';
    }
}

