/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.exceptions;

import java.util.Objects;

public class BaseException
extends Exception {
    private final int startPosition;
    private final int endPosition;
    private final String tokenString;
    private final String message;

    public BaseException(int startPosition, int endPosition, String tokenString, String message) {
        super(message);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.tokenString = tokenString;
        this.message = super.getMessage();
    }

    public BaseException(int startPosition, int endPosition, String tokenString, Throwable cause) {
        super(cause);
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.tokenString = tokenString;
        this.message = cause.getMessage();
    }

    @Override
    public String toString() {
        return "BaseException(startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + ", tokenString=" + this.tokenString + ", message=" + this.message + ")";
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseException that = (BaseException)o;
        return this.startPosition == that.startPosition && this.endPosition == that.endPosition && Objects.equals(this.tokenString, that.tokenString) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.startPosition, this.endPosition, this.tokenString, this.message);
    }
}

