/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.parser;

import de.flapdoodle.eval.core.parser.ImmutableASTNode;
import de.flapdoodle.eval.core.parser.Token;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ASTNode {
    public abstract List<ASTNode> getParameters();

    public abstract Token getToken();

    public static ASTNode of(Token token, ASTNode ... parameters) {
        return ImmutableASTNode.builder().token(token).addParameters(parameters).build();
    }

    public String toJSON() {
        if (this.getParameters().isEmpty()) {
            return String.format("{\"type\":\"%s\",\"value\":\"%s\"}", new Object[]{this.getToken().type(), this.getToken().value()});
        }
        String childrenJson = this.getParameters().stream().map(ASTNode::toJSON).collect(Collectors.joining(","));
        return String.format("{\"type\":\"%s\",\"value\":\"%s\",\"children\":[%s]}", new Object[]{this.getToken().type(), this.getToken().value(), childrenJson});
    }
}

