/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.parser;

import de.flapdoodle.eval.core.parser.ASTNode;
import de.flapdoodle.eval.core.parser.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ASTNode", generator="Immutables")
public final class ImmutableASTNode
extends ASTNode {
    private final List<ASTNode> parameters;
    private final Token token;

    private ImmutableASTNode(List<ASTNode> parameters, Token token) {
        this.parameters = parameters;
        this.token = token;
    }

    @Override
    public List<ASTNode> getParameters() {
        return this.parameters;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public final ImmutableASTNode withParameters(ASTNode ... elements) {
        List<ASTNode> newValue = ImmutableASTNode.createUnmodifiableList(false, ImmutableASTNode.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableASTNode(newValue, this.token);
    }

    public final ImmutableASTNode withParameters(Iterable<? extends ASTNode> elements) {
        if (this.parameters == elements) {
            return this;
        }
        List<ASTNode> newValue = ImmutableASTNode.createUnmodifiableList(false, ImmutableASTNode.createSafeList(elements, true, false));
        return new ImmutableASTNode(newValue, this.token);
    }

    public final ImmutableASTNode withToken(Token value) {
        if (this.token == value) {
            return this;
        }
        Token newValue = Objects.requireNonNull(value, "token");
        return new ImmutableASTNode(this.parameters, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableASTNode && this.equalTo(0, (ImmutableASTNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableASTNode another) {
        return this.parameters.equals(another.parameters) && this.token.equals(another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parameters.hashCode();
        h += (h << 5) + this.token.hashCode();
        return h;
    }

    public String toString() {
        return "ASTNode{parameters=" + this.parameters + ", token=" + this.token + "}";
    }

    public static ImmutableASTNode copyOf(ASTNode instance) {
        if (instance instanceof ImmutableASTNode) {
            return (ImmutableASTNode)instance;
        }
        return ImmutableASTNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ASTNode", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private long initBits = 1L;
        private List<ASTNode> parameters = new ArrayList<ASTNode>();
        private Token token;

        private Builder() {
        }

        public final Builder from(ASTNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllParameters(instance.getParameters());
            this.token(instance.getToken());
            return this;
        }

        public final Builder addParameters(ASTNode element) {
            this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            return this;
        }

        public final Builder addParameters(ASTNode ... elements) {
            for (ASTNode element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            return this;
        }

        public final Builder parameters(Iterable<? extends ASTNode> elements) {
            this.parameters.clear();
            return this.addAllParameters(elements);
        }

        public final Builder addAllParameters(Iterable<? extends ASTNode> elements) {
            for (ASTNode aSTNode : elements) {
                this.parameters.add(Objects.requireNonNull(aSTNode, "parameters element"));
            }
            return this;
        }

        public final Builder token(Token token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableASTNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableASTNode(ImmutableASTNode.createUnmodifiableList(true, this.parameters), this.token);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build ASTNode, some of required attributes are not set " + attributes;
        }
    }
}

