/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.VariableTypeResolver;
import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.tree.EvaluableExceptionMapper;
import de.flapdoodle.eval.core.tree.ImmutableEvaluatableNode;
import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class EvaluatableNode
extends Node {
    @Value.Parameter
    protected abstract TypedEvaluableByArguments evaluatable();

    @Value.Parameter
    protected abstract List<Node> parameters();

    @Value.Parameter
    protected abstract EvaluableExceptionMapper exceptionMapper();

    @Override
    public Evaluated<?> evaluate(VariableResolver variableResolver, EvaluationContext context) throws EvaluationException {
        ArrayList parameterResults = new ArrayList();
        for (int i = 0; i < this.parameters().size(); ++i) {
            Node parameter = this.parameters().get(i);
            try {
                parameterResults.add(parameter.evaluate(variableResolver, context));
                continue;
            }
            catch (EvaluationException ex) {
                parameterResults.add(Evaluated.value(this.exceptionMapper().map(ex)));
            }
        }
        Either<TypedEvaluable<?>, EvaluableException> evaluatable = this.evaluatable().find(parameterResults);
        if (evaluatable.isLeft()) {
            try {
                Evaluated evaluated = ((TypedEvaluable)evaluatable.left()).evaluate(variableResolver, context, this.token(), parameterResults);
                Optional<EvaluationException> matchedException = this.exceptionMapper().match(evaluated);
                if (matchedException.isPresent()) {
                    throw matchedException.get();
                }
                return evaluated;
            }
            catch (EvaluationException.AsRuntimeException wrapping) {
                throw wrapping.wrapped();
            }
        }
        throw new EvaluationException(this.token(), (EvaluableException)evaluatable.right());
    }

    @Override
    public TypeInfo<?> evaluateType(VariableTypeResolver variableResolver) throws EvaluationException {
        ArrayList parameterResults = new ArrayList();
        for (int i = 0; i < this.parameters().size(); ++i) {
            Node parameter = this.parameters().get(i);
            try {
                parameterResults.add(parameter.evaluateType(variableResolver));
                continue;
            }
            catch (EvaluationException ex) {
                parameterResults.add(Evaluated.value(this.exceptionMapper().map(ex)).type());
            }
        }
        Either<TypedEvaluable<?>, EvaluableException> evaluatable = this.evaluatable().findType(parameterResults);
        if (evaluatable.isLeft()) {
            try {
                TypeInfo evaluatedType = ((TypedEvaluable)evaluatable.left()).signature().returnType();
                return evaluatedType;
            }
            catch (EvaluationException.AsRuntimeException wrapping) {
                throw wrapping.wrapped();
            }
        }
        throw new EvaluationException(this.token(), (EvaluableException)evaluatable.right());
    }

    public static EvaluatableNode of(Token token, TypedEvaluableByArguments function, List<Node> parameters, EvaluableExceptionMapper exceptionMapper) {
        return ImmutableEvaluatableNode.builder().token(token).evaluatable(function).parameters(parameters).exceptionMapper(exceptionMapper).build();
    }
}

