/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.tree.EvaluableExceptionMapper;
import de.flapdoodle.eval.core.tree.EvaluatableNode;
import de.flapdoodle.eval.core.tree.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="EvaluatableNode", generator="Immutables")
public final class ImmutableEvaluatableNode
extends EvaluatableNode {
    private final Token token;
    private final TypedEvaluableByArguments evaluatable;
    private final List<Node> parameters;
    private final EvaluableExceptionMapper exceptionMapper;

    private ImmutableEvaluatableNode(Token token, TypedEvaluableByArguments evaluatable, Iterable<? extends Node> parameters, EvaluableExceptionMapper exceptionMapper) {
        this.token = Objects.requireNonNull(token, "token");
        this.evaluatable = Objects.requireNonNull(evaluatable, "evaluatable");
        this.parameters = ImmutableEvaluatableNode.createUnmodifiableList(false, ImmutableEvaluatableNode.createSafeList(parameters, true, false));
        this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper");
    }

    private ImmutableEvaluatableNode(ImmutableEvaluatableNode original, Token token, TypedEvaluableByArguments evaluatable, List<Node> parameters, EvaluableExceptionMapper exceptionMapper) {
        this.token = token;
        this.evaluatable = evaluatable;
        this.parameters = parameters;
        this.exceptionMapper = exceptionMapper;
    }

    @Override
    public Token token() {
        return this.token;
    }

    @Override
    protected TypedEvaluableByArguments evaluatable() {
        return this.evaluatable;
    }

    @Override
    protected List<Node> parameters() {
        return this.parameters;
    }

    @Override
    protected EvaluableExceptionMapper exceptionMapper() {
        return this.exceptionMapper;
    }

    public final ImmutableEvaluatableNode withToken(Token value) {
        if (this.token == value) {
            return this;
        }
        Token newValue = Objects.requireNonNull(value, "token");
        return new ImmutableEvaluatableNode(this, newValue, this.evaluatable, this.parameters, this.exceptionMapper);
    }

    public final ImmutableEvaluatableNode withEvaluatable(TypedEvaluableByArguments value) {
        if (this.evaluatable == value) {
            return this;
        }
        TypedEvaluableByArguments newValue = Objects.requireNonNull(value, "evaluatable");
        return new ImmutableEvaluatableNode(this, this.token, newValue, this.parameters, this.exceptionMapper);
    }

    public final ImmutableEvaluatableNode withParameters(Node ... elements) {
        List<Node> newValue = ImmutableEvaluatableNode.createUnmodifiableList(false, ImmutableEvaluatableNode.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEvaluatableNode(this, this.token, this.evaluatable, newValue, this.exceptionMapper);
    }

    public final ImmutableEvaluatableNode withParameters(Iterable<? extends Node> elements) {
        if (this.parameters == elements) {
            return this;
        }
        List<Node> newValue = ImmutableEvaluatableNode.createUnmodifiableList(false, ImmutableEvaluatableNode.createSafeList(elements, true, false));
        return new ImmutableEvaluatableNode(this, this.token, this.evaluatable, newValue, this.exceptionMapper);
    }

    public final ImmutableEvaluatableNode withExceptionMapper(EvaluableExceptionMapper value) {
        if (this.exceptionMapper == value) {
            return this;
        }
        EvaluableExceptionMapper newValue = Objects.requireNonNull(value, "exceptionMapper");
        return new ImmutableEvaluatableNode(this, this.token, this.evaluatable, this.parameters, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvaluatableNode && this.equalTo(0, (ImmutableEvaluatableNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableEvaluatableNode another) {
        return this.token.equals(another.token) && this.evaluatable.equals(another.evaluatable) && this.parameters.equals(another.parameters) && this.exceptionMapper.equals(another.exceptionMapper);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.evaluatable.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        h += (h << 5) + this.exceptionMapper.hashCode();
        return h;
    }

    public String toString() {
        return "EvaluatableNode{token=" + this.token + ", evaluatable=" + this.evaluatable + ", parameters=" + this.parameters + ", exceptionMapper=" + this.exceptionMapper + "}";
    }

    public static ImmutableEvaluatableNode of(Token token, TypedEvaluableByArguments evaluatable, List<Node> parameters, EvaluableExceptionMapper exceptionMapper) {
        return ImmutableEvaluatableNode.of(token, evaluatable, parameters, exceptionMapper);
    }

    public static ImmutableEvaluatableNode of(Token token, TypedEvaluableByArguments evaluatable, Iterable<? extends Node> parameters, EvaluableExceptionMapper exceptionMapper) {
        return new ImmutableEvaluatableNode(token, evaluatable, parameters, exceptionMapper);
    }

    public static ImmutableEvaluatableNode copyOf(EvaluatableNode instance) {
        if (instance instanceof ImmutableEvaluatableNode) {
            return (ImmutableEvaluatableNode)instance;
        }
        return ImmutableEvaluatableNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="EvaluatableNode", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_EVALUATABLE = 2L;
        private static final long INIT_BIT_EXCEPTION_MAPPER = 4L;
        private long initBits = 7L;
        private Token token;
        private TypedEvaluableByArguments evaluatable;
        private List<Node> parameters = new ArrayList<Node>();
        private EvaluableExceptionMapper exceptionMapper;

        private Builder() {
        }

        public final Builder from(EvaluatableNode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Node instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Node instance;
            if (object instanceof EvaluatableNode) {
                instance = (EvaluatableNode)object;
                this.exceptionMapper(((EvaluatableNode)instance).exceptionMapper());
                this.addAllParameters(((EvaluatableNode)instance).parameters());
                this.evaluatable(((EvaluatableNode)instance).evaluatable());
            }
            if (object instanceof Node) {
                instance = (Node)object;
                this.token(instance.token());
            }
        }

        public final Builder token(Token token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder evaluatable(TypedEvaluableByArguments evaluatable) {
            this.evaluatable = Objects.requireNonNull(evaluatable, "evaluatable");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addParameters(Node element) {
            this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            return this;
        }

        public final Builder addParameters(Node ... elements) {
            for (Node element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            return this;
        }

        public final Builder parameters(Iterable<? extends Node> elements) {
            this.parameters.clear();
            return this.addAllParameters(elements);
        }

        public final Builder addAllParameters(Iterable<? extends Node> elements) {
            for (Node node : elements) {
                this.parameters.add(Objects.requireNonNull(node, "parameters element"));
            }
            return this;
        }

        public final Builder exceptionMapper(EvaluableExceptionMapper exceptionMapper) {
            this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEvaluatableNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEvaluatableNode(null, this.token, this.evaluatable, ImmutableEvaluatableNode.createUnmodifiableList(true, this.parameters), this.exceptionMapper);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("evaluatable");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("exceptionMapper");
            }
            return "Cannot build EvaluatableNode, some of required attributes are not set " + attributes;
        }
    }
}

