/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.tree.Variable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Variable", generator="Immutables")
public final class ImmutableVariable
extends Variable {
    private final int hash;
    private final String name;
    private final int position;

    private ImmutableVariable(int hash, String name, int position) {
        this.hash = hash;
        this.name = Objects.requireNonNull(name, "name");
        this.position = position;
    }

    private ImmutableVariable(ImmutableVariable original, int hash, String name, int position) {
        this.hash = hash;
        this.name = name;
        this.position = position;
    }

    @Override
    public int hash() {
        return this.hash;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int position() {
        return this.position;
    }

    public final ImmutableVariable withHash(int value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableVariable(this, value, this.name, this.position);
    }

    public final ImmutableVariable withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableVariable(this, this.hash, newValue, this.position);
    }

    public final ImmutableVariable withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableVariable(this, this.hash, this.name, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariable && this.equalTo(0, (ImmutableVariable)another);
    }

    private boolean equalTo(int synthetic, ImmutableVariable another) {
        return this.hash == another.hash && this.name.equals(another.name) && this.position == another.position;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hash;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.position;
        return h;
    }

    public String toString() {
        return "Variable{hash=" + this.hash + ", name=" + this.name + ", position=" + this.position + "}";
    }

    public static ImmutableVariable of(int hash, String name, int position) {
        return new ImmutableVariable(hash, name, position);
    }

    public static ImmutableVariable copyOf(Variable instance) {
        if (instance instanceof ImmutableVariable) {
            return (ImmutableVariable)instance;
        }
        return ImmutableVariable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Variable", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_POSITION = 4L;
        private long initBits = 7L;
        private int hash;
        private String name;
        private int position;

        private Builder() {
        }

        public final Builder from(Variable instance) {
            Objects.requireNonNull(instance, "instance");
            this.hash(instance.hash());
            this.name(instance.name());
            this.position(instance.position());
            return this;
        }

        public final Builder hash(int hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableVariable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVariable(null, this.hash, this.name, this.position);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("position");
            }
            return "Cannot build Variable, some of required attributes are not set " + attributes;
        }
    }
}

