/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.tree.Variable;
import de.flapdoodle.eval.core.tree.Variables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="Variables", generator="Immutables")
public final class ImmutableVariables
extends Variables {
    private final List<Variable> list;
    private final transient Map<String, Integer> nameHashMap;
    private final transient Set<String> names;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVariables(List<Variable> list) {
        this.list = list;
        this.nameHashMap = this.initShim.nameHashMap();
        this.names = this.initShim.names();
        this.initShim = null;
    }

    @Override
    public List<Variable> list() {
        return this.list;
    }

    @Override
    public Map<String, Integer> nameHashMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nameHashMap() : this.nameHashMap;
    }

    @Override
    public Set<String> names() {
        InitShim shim = this.initShim;
        return shim != null ? shim.names() : this.names;
    }

    public final ImmutableVariables withList(Variable ... elements) {
        List<Variable> newValue = ImmutableVariables.createUnmodifiableList(false, ImmutableVariables.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableVariables(newValue);
    }

    public final ImmutableVariables withList(Iterable<? extends Variable> elements) {
        if (this.list == elements) {
            return this;
        }
        List<Variable> newValue = ImmutableVariables.createUnmodifiableList(false, ImmutableVariables.createSafeList(elements, true, false));
        return new ImmutableVariables(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVariables && this.equalTo(0, (ImmutableVariables)another);
    }

    private boolean equalTo(int synthetic, ImmutableVariables another) {
        return this.list.equals(another.list) && this.nameHashMap.equals(another.nameHashMap) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.list.hashCode();
        h += (h << 5) + this.nameHashMap.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return "Variables{list=" + this.list + ", nameHashMap=" + this.nameHashMap + ", names=" + this.names + "}";
    }

    public static ImmutableVariables copyOf(Variables instance) {
        if (instance instanceof ImmutableVariables) {
            return (ImmutableVariables)instance;
        }
        return ImmutableVariables.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Variables", generator="Immutables")
    public static final class Builder {
        private List<Variable> list = new ArrayList<Variable>();

        private Builder() {
        }

        public final Builder from(Variables instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllList(instance.list());
            return this;
        }

        public final Builder addList(Variable element) {
            this.list.add(Objects.requireNonNull(element, "list element"));
            return this;
        }

        public final Builder addList(Variable ... elements) {
            for (Variable element : elements) {
                this.list.add(Objects.requireNonNull(element, "list element"));
            }
            return this;
        }

        public final Builder list(Iterable<? extends Variable> elements) {
            this.list.clear();
            return this.addAllList(elements);
        }

        public final Builder addAllList(Iterable<? extends Variable> elements) {
            for (Variable variable : elements) {
                this.list.add(Objects.requireNonNull(variable, "list element"));
            }
            return this;
        }

        public ImmutableVariables build() {
            return new ImmutableVariables(ImmutableVariables.createUnmodifiableList(true, this.list));
        }
    }

    @Generated(from="Variables", generator="Immutables")
    private final class InitShim {
        private byte nameHashMapBuildStage = 0;
        private Map<String, Integer> nameHashMap;
        private byte namesBuildStage = 0;
        private Set<String> names;

        private InitShim() {
        }

        Map<String, Integer> nameHashMap() {
            if (this.nameHashMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameHashMapBuildStage == 0) {
                this.nameHashMapBuildStage = (byte)-1;
                this.nameHashMap = Objects.requireNonNull(ImmutableVariables.super.nameHashMap(), "nameHashMap");
                this.nameHashMapBuildStage = 1;
            }
            return this.nameHashMap;
        }

        Set<String> names() {
            if (this.namesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.namesBuildStage == 0) {
                this.namesBuildStage = (byte)-1;
                this.names = Objects.requireNonNull(ImmutableVariables.super.names(), "names");
                this.namesBuildStage = 1;
            }
            return this.names;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nameHashMapBuildStage == -1) {
                attributes.add("nameHashMap");
            }
            if (this.namesBuildStage == -1) {
                attributes.add("names");
            }
            return "Cannot build Variables, attribute initializers form cycle " + attributes;
        }
    }
}

