/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.VariableTypeResolver;
import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.tree.ImmutableLookupNode;
import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.reflection.TypeInfo;
import org.immutables.value.Value;

@Value.Immutable
public abstract class LookupNode
extends Node {
    @Override
    public Evaluated<?> evaluate(VariableResolver variableResolver, EvaluationContext context) throws EvaluationException {
        Evaluated<?> result = variableResolver.get(this.token().value());
        if (result == null) {
            throw new EvaluationException(this.token(), String.format("Variable or constant value for '%s' not found", this.token().value()));
        }
        return result;
    }

    @Override
    public TypeInfo<?> evaluateType(VariableTypeResolver variableResolver) throws EvaluationException {
        TypeInfo<?> result = variableResolver.get(this.token().value());
        if (result == null) {
            throw new EvaluationException(this.token(), String.format("Variable or constant value for '%s' not found", this.token().value()));
        }
        return result;
    }

    public static LookupNode of(Token token) {
        return ImmutableLookupNode.builder().token(token).build();
    }
}

