/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.eval.core.tree.ImmutableVariables;
import de.flapdoodle.eval.core.tree.Variable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Variables {
    public abstract List<Variable> list();

    @Value.Derived
    public Map<String, Integer> nameHashMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        this.list().forEach(pair -> map.putIfAbsent(pair.name(), pair.hash()));
        return map;
    }

    @Value.Derived
    public Set<String> names() {
        return this.nameHashMap().keySet();
    }

    @Value.Auxiliary
    public int firstHashOf(String name) {
        return (Integer)Preconditions.checkNotNull((Object)this.nameHashMap().get(name), (String)"could not find hash of %s", (Object[])new Object[]{name});
    }

    @Deprecated
    @Value.Auxiliary
    public int hashOf(String name) {
        return this.firstHashOf(name);
    }

    public static ImmutableVariables.Builder builder() {
        return ImmutableVariables.builder();
    }
}

