/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example;

import de.flapdoodle.eval.core.Nullable;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.example.ImmutableArrayValue;
import de.flapdoodle.eval.example.ImmutableBooleanValue;
import de.flapdoodle.eval.example.ImmutableDateTimeValue;
import de.flapdoodle.eval.example.ImmutableDurationValue;
import de.flapdoodle.eval.example.ImmutableFailedWithException;
import de.flapdoodle.eval.example.ImmutableMapValue;
import de.flapdoodle.eval.example.ImmutableNullValue;
import de.flapdoodle.eval.example.ImmutableNumberValue;
import de.flapdoodle.eval.example.ImmutableStringValue;
import de.flapdoodle.eval.example.ValueMap;
import de.flapdoodle.eval.example.Values;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

public abstract class Value<T> {
    @Deprecated
    public static final BooleanValue TRUE = Value.of(Boolean.TRUE);
    @Deprecated
    public static final BooleanValue FALSE = Value.of(Boolean.FALSE);
    private static NullValue NULL = ImmutableNullValue.builder().build();

    @Value.Parameter
    public abstract T wrapped();

    @Value.Auxiliary
    public String toString() {
        return this.wrapped().toString();
    }

    public static StringValue of(String value) {
        return ImmutableStringValue.of(value);
    }

    public static NumberValue of(BigDecimal value) {
        return ImmutableNumberValue.of(value);
    }

    public static NumberValue of(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("is " + value);
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("is " + value);
        }
        return Value.of(BigDecimal.valueOf(value));
    }

    public static NullValue ofNull() {
        return NULL;
    }

    public static BooleanValue of(Boolean value) {
        return ImmutableBooleanValue.of(value);
    }

    public static DateTimeValue of(Instant value) {
        return ImmutableDateTimeValue.of(value);
    }

    public static DurationValue of(Duration value) {
        return ImmutableDurationValue.of(value);
    }

    public static ArrayValue of(Values value) {
        return ImmutableArrayValue.of(value);
    }

    public static MapValue of(ValueMap value) {
        return ImmutableMapValue.of(value);
    }

    public static <T> MapValue of(Function<T, Value<?>> mapper, Map<String, T> map) {
        return Value.of(ValueMap.of(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Value)mapper.apply(entry.getValue())))));
    }

    public static ArrayValue of(Collection<? extends Value<?>> array) {
        return ImmutableArrayValue.of(Values.of(array));
    }

    public static <T> ArrayValue of(Function<T, Value<?>> mapper, Collection<? extends T> array) {
        return Value.of(array.stream().map(mapper).collect(Collectors.toList()));
    }

    public static <T> ArrayValue of(Function<T, Value<?>> mapper, T ... array) {
        return Value.of(Stream.of(array).map(mapper).collect(Collectors.toList()));
    }

    public static ArrayValue of(Value<?> ... array) {
        return Value.of(Values.of(Arrays.asList(array)));
    }

    public static Value<?> failedWith(EvaluationException rx) {
        return ImmutableFailedWithException.builder().exception(rx).build();
    }

    @Value.Immutable
    public static abstract class FailedWithException<T>
    extends Value<T> {
        public abstract EvaluationException exception();

        @Override
        @Nullable
        @Value.Lazy
        public T wrapped() {
            throw new EvaluationException.AsRuntimeException(this.exception());
        }

        @Override
        @Value.Auxiliary
        public String toString() {
            return "FailedWithException(exception=" + this.exception() + ")";
        }
    }

    @Value.Immutable
    public static abstract class MapValue
    extends Value<ValueMap> {
    }

    @Value.Immutable
    public static abstract class ArrayValue
    extends Value<Values> {
    }

    @Value.Immutable
    public static abstract class DurationValue
    extends Value<Duration>
    implements Comparable<DurationValue> {
        @Override
        @Value.Auxiliary
        public int compareTo(DurationValue other) {
            return ((Duration)this.wrapped()).compareTo((Duration)other.wrapped());
        }
    }

    @Value.Immutable
    public static abstract class DateTimeValue
    extends Value<Instant>
    implements Comparable<DateTimeValue> {
        @Override
        @Value.Auxiliary
        public int compareTo(DateTimeValue other) {
            return ((Instant)this.wrapped()).compareTo((Instant)other.wrapped());
        }
    }

    @Value.Immutable
    public static abstract class BooleanValue
    extends Value<Boolean>
    implements Comparable<BooleanValue> {
        @Override
        @Value.Auxiliary
        public int compareTo(BooleanValue other) {
            return ((Boolean)this.wrapped()).compareTo((Boolean)other.wrapped());
        }
    }

    @Value.Immutable
    public static abstract class NumberValue
    extends Value<BigDecimal>
    implements Comparable<NumberValue> {
        @Override
        @Value.Auxiliary
        public int compareTo(NumberValue other) {
            return ((BigDecimal)this.wrapped()).compareTo((BigDecimal)other.wrapped());
        }
    }

    @Value.Immutable
    public static abstract class StringValue
    extends Value<String>
    implements Comparable<StringValue> {
        @Override
        @Value.Auxiliary
        public int compareTo(StringValue other) {
            return ((String)this.wrapped()).compareTo((String)other.wrapped());
        }
    }

    @Value.Immutable
    public static abstract class NullValue
    extends Value<Void> {
        @Override
        @Nullable
        public abstract Void wrapped();

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

