/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.arithmetic;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.example.Value;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;

public class Minus
extends TypedEvaluables.Wrapper {
    public Minus() {
        super(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Value.NumberValue.class, Value.NumberValue.class, new Number())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Value.DateTimeValue.class, Value.DurationValue.class, new DateTimeDuration())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DurationValue.class, Value.DateTimeValue.class, Value.DateTimeValue.class, new DateTimeDateTime())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DurationValue.class, Value.DurationValue.class, Value.DurationValue.class, new Durations())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Value.DateTimeValue.class, Value.NumberValue.class, new DateTimeNumber())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Value.NumberValue.class, new Negate())).build());
    }

    public static class Negate
    implements TypedEvaluable.Arg1<Value.NumberValue, Value.NumberValue> {
        @Override
        public Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue first) throws EvaluationException {
            return Value.of(((BigDecimal)first.wrapped()).negate(evaluationContext.mathContext()));
        }
    }

    public static class DateTimeNumber
    implements TypedEvaluable.Arg2<Value.DateTimeValue, Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DateTimeValue first, Value.NumberValue second) throws EvaluationException {
            return Value.of(((Instant)first.wrapped()).minus(Duration.ofMillis(((BigDecimal)second.wrapped()).longValue())));
        }
    }

    public static class Durations
    implements TypedEvaluable.Arg2<Value.DurationValue, Value.DurationValue, Value.DurationValue> {
        @Override
        public Value.DurationValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DurationValue first, Value.DurationValue second) throws EvaluationException {
            return Value.of(((Duration)first.wrapped()).minus((Duration)second.wrapped()));
        }
    }

    public static class DateTimeDateTime
    implements TypedEvaluable.Arg2<Value.DateTimeValue, Value.DateTimeValue, Value.DurationValue> {
        @Override
        public Value.DurationValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DateTimeValue first, Value.DateTimeValue second) throws EvaluationException {
            return Value.of(Duration.ofMillis(((Instant)first.wrapped()).toEpochMilli() - ((Instant)second.wrapped()).toEpochMilli()));
        }
    }

    public static class DateTimeDuration
    implements TypedEvaluable.Arg2<Value.DateTimeValue, Value.DurationValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DateTimeValue first, Value.DurationValue second) throws EvaluationException {
            return Value.of(((Instant)first.wrapped()).minus((TemporalAmount)second.wrapped()));
        }
    }

    public static class Number
    implements TypedEvaluable.Arg2<Value.NumberValue, Value.NumberValue, Value.NumberValue> {
        @Override
        public Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue first, Value.NumberValue second) throws EvaluationException {
            return Value.of(((BigDecimal)first.wrapped()).subtract((BigDecimal)second.wrapped(), evaluationContext.mathContext()));
        }
    }
}

