/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.arithmetic;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.example.Value;
import de.flapdoodle.eval.example.evaluables.validation.NumberValidator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class Sqrt
extends TypedEvaluables.Wrapper {
    public Sqrt() {
        super(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Parameter.of(Value.NumberValue.class).withValidators(NumberValidator.greaterOrEqualThan(BigDecimal.ZERO)), new Number())).build());
    }

    public static class Number
    implements TypedEvaluable.Arg1<Value.NumberValue, Value.NumberValue> {
        private static final BigDecimal ONE_TENTH = BigDecimal.valueOf(1L, 1);
        private static final BigDecimal ONE_HALF = BigDecimal.valueOf(5L, 1);

        @Override
        public Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue argument) throws EvaluationException {
            return Value.of(Number.sqrt((BigDecimal)argument.wrapped(), evaluationContext.mathContext()));
        }

        private static boolean isPowerOfTen(BigDecimal thi) {
            return BigInteger.ONE.equals(thi.unscaledValue());
        }

        private static BigDecimal sqrt(BigDecimal thi, MathContext mc) {
            int signum = thi.signum();
            if (signum == 1) {
                BigDecimal result;
                int targetPrecision;
                int preferredScale = thi.scale() / 2;
                BigDecimal zeroWithFinalPreferredScale = BigDecimal.valueOf(0L, preferredScale);
                BigDecimal stripped = thi.stripTrailingZeros();
                int strippedScale = stripped.scale();
                if (Number.isPowerOfTen(stripped) && strippedScale % 2 == 0) {
                    BigDecimal result2 = BigDecimal.valueOf(1L, strippedScale / 2);
                    if (result2.scale() != preferredScale) {
                        result2 = result2.add(zeroWithFinalPreferredScale, mc);
                    }
                    return result2;
                }
                int scaleAdjust = 0;
                int scale = stripped.scale() - stripped.precision() + 1;
                scaleAdjust = scale % 2 == 0 ? scale : scale - 1;
                BigDecimal working = stripped.scaleByPowerOfTen(scaleAdjust);
                assert (ONE_TENTH.compareTo(working) <= 0 && working.compareTo(BigDecimal.TEN) < 0);
                BigDecimal guess = new BigDecimal(Math.sqrt(working.doubleValue()));
                int guessPrecision = 15;
                int originalPrecision = mc.getPrecision();
                if (originalPrecision == 0) {
                    targetPrecision = stripped.precision() / 2 + 1;
                } else {
                    switch (mc.getRoundingMode()) {
                        case HALF_UP: 
                        case HALF_DOWN: 
                        case HALF_EVEN: {
                            targetPrecision = 2 * originalPrecision;
                            if (targetPrecision >= 0) break;
                            targetPrecision = 0x7FFFFFFD;
                            break;
                        }
                        default: {
                            targetPrecision = originalPrecision;
                        }
                    }
                }
                BigDecimal approx = guess;
                int workingPrecision = working.precision();
                do {
                    int tmpPrecision = Math.max(Math.max(guessPrecision, targetPrecision + 2), workingPrecision);
                    MathContext mcTmp = new MathContext(tmpPrecision, RoundingMode.HALF_EVEN);
                    approx = ONE_HALF.multiply(approx.add(working.divide(approx, mcTmp), mcTmp));
                } while ((guessPrecision *= 2) < targetPrecision + 2);
                RoundingMode targetRm = mc.getRoundingMode();
                if (targetRm == RoundingMode.UNNECESSARY || originalPrecision == 0) {
                    RoundingMode tmpRm = targetRm == RoundingMode.UNNECESSARY ? RoundingMode.DOWN : targetRm;
                    MathContext mcTmp = new MathContext(targetPrecision, tmpRm);
                    result = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mcTmp);
                    if (thi.subtract(result.multiply(result)).compareTo(BigDecimal.ZERO) != 0) {
                        throw new ArithmeticException("Computed square root not exact.");
                    }
                } else {
                    result = approx.scaleByPowerOfTen(-scaleAdjust / 2).round(mc);
                    switch (targetRm) {
                        case DOWN: 
                        case FLOOR: {
                            if (result.multiply(result).compareTo(thi) <= 0) break;
                            BigDecimal ulp = result.ulp();
                            if (approx.compareTo(BigDecimal.ONE) == 0) {
                                ulp = ulp.multiply(ONE_TENTH);
                            }
                            result = result.subtract(ulp);
                            break;
                        }
                        case UP: 
                        case CEILING: {
                            if (result.multiply(result).compareTo(thi) >= 0) break;
                            result = result.add(result.ulp());
                            break;
                        }
                    }
                }
                if (result.scale() != preferredScale) {
                    result = result.stripTrailingZeros().add(zeroWithFinalPreferredScale, new MathContext(originalPrecision, RoundingMode.UNNECESSARY));
                }
                return result;
            }
            BigDecimal result = null;
            switch (signum) {
                case -1: {
                    throw new ArithmeticException("Attempted square root of negative BigDecimal");
                }
                case 0: {
                    result = BigDecimal.valueOf(0L, thi.scale() / 2);
                    return result;
                }
            }
            throw new AssertionError((Object)"Bad value from signum");
        }
    }
}

