/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.datetime;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.example.Value;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class FormatDateTime
extends TypedEvaluables.Wrapper {
    public FormatDateTime() {
        super(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.StringValue.class, Value.DateTimeValue.class, new ToString())).addList((TypedEvaluable<?>)TypedEvaluable.of(Value.StringValue.class, Value.DateTimeValue.class, Value.StringValue.class, new FormatString())).build());
    }

    public static class FormatString
    implements TypedEvaluable.Arg2<Value.DateTimeValue, Value.StringValue, Value.StringValue> {
        @Override
        public Value.StringValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DateTimeValue dateTime, Value.StringValue format) throws EvaluationException {
            LocalDateTime dateTimeValue = ((Instant)dateTime.wrapped()).atZone(evaluationContext.zoneId()).toLocalDateTime();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)format.wrapped());
            return Value.of(dateTimeValue.format(formatter));
        }
    }

    public static class ToString
    implements TypedEvaluable.Arg1<Value.DateTimeValue, Value.StringValue> {
        @Override
        public Value.StringValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DateTimeValue dateTime) throws EvaluationException {
            LocalDateTime dateTimeValue = ((Instant)dateTime.wrapped()).atZone(evaluationContext.zoneId()).toLocalDateTime();
            return Value.of(dateTimeValue.toString());
        }
    }
}

