/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.datetime;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.example.Value;
import java.math.BigDecimal;
import java.time.Instant;

public class Legacy
extends TypedEvaluables.Wrapper {
    private Legacy(TypedEvaluables delegate) {
        super(delegate);
    }

    public static Legacy epochFromNumber() {
        return new Legacy(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.DateTimeValue.class, Value.NumberValue.class, new EpochFromNumber())).build());
    }

    public static Legacy dateTime2Epoch() {
        return new Legacy(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Value.DateTimeValue.class, new DateTime2Epoch())).build());
    }

    public static class DateTime2Epoch
    implements TypedEvaluable.Arg1<Value.DateTimeValue, Value.NumberValue> {
        @Override
        public Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.DateTimeValue argument) throws EvaluationException {
            return Value.of(((Instant)argument.wrapped()).toEpochMilli());
        }
    }

    public static class EpochFromNumber
    implements TypedEvaluable.Arg1<Value.NumberValue, Value.DateTimeValue> {
        @Override
        public Value.DateTimeValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue argument) throws EvaluationException {
            return Value.of(Instant.ofEpochMilli(((BigDecimal)argument.wrapped()).longValue()));
        }
    }
}

