package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.eval.core.tree.Variables;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Expression}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExpression.builder()}.
 */
@Generated(from = "Expression", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableExpression extends Expression {
  private final MathContext mathContext;
  private final ZoneId zoneId;
  private final String source;
  private final Node root;
  private transient final Variables variables;
  private transient final Set<String> usedVariables;

  private ImmutableExpression(
      MathContext mathContext,
      ZoneId zoneId,
      String source,
      Node root) {
    this.mathContext = mathContext;
    this.zoneId = zoneId;
    this.source = source;
    this.root = root;
    this.variables = initShim.variables();
    this.usedVariables = initShim.usedVariables();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Expression", generator = "Immutables")
  private final class InitShim {
    private byte variablesBuildStage = STAGE_UNINITIALIZED;
    private Variables variables;

    Variables variables() {
      if (variablesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (variablesBuildStage == STAGE_UNINITIALIZED) {
        variablesBuildStage = STAGE_INITIALIZING;
        this.variables = Objects.requireNonNull(ImmutableExpression.super.variables(), "variables");
        variablesBuildStage = STAGE_INITIALIZED;
      }
      return this.variables;
    }

    private byte usedVariablesBuildStage = STAGE_UNINITIALIZED;
    private Set<String> usedVariables;

    Set<String> usedVariables() {
      if (usedVariablesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usedVariablesBuildStage == STAGE_UNINITIALIZED) {
        usedVariablesBuildStage = STAGE_INITIALIZING;
        this.usedVariables = Objects.requireNonNull(ImmutableExpression.super.usedVariables(), "usedVariables");
        usedVariablesBuildStage = STAGE_INITIALIZED;
      }
      return this.usedVariables;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (variablesBuildStage == STAGE_INITIALIZING) attributes.add("variables");
      if (usedVariablesBuildStage == STAGE_INITIALIZING) attributes.add("usedVariables");
      return "Cannot build Expression, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code mathContext} attribute
   */
  @Override
  protected MathContext mathContext() {
    return mathContext;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @Override
  protected ZoneId zoneId() {
    return zoneId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @Override
  public String source() {
    return source;
  }

  /**
   * @return The value of the {@code root} attribute
   */
  @Override
  public Node root() {
    return root;
  }

  /**
   * @return The computed-at-construction value of the {@code variables} attribute
   */
  @Override
  public Variables variables() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.variables()
        : this.variables;
  }

  /**
   * @return The computed-at-construction value of the {@code usedVariables} attribute
   */
  @Override
  public Set<String> usedVariables() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.usedVariables()
        : this.usedVariables;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Expression#mathContext() mathContext} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mathContext
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpression withMathContext(MathContext value) {
    if (this.mathContext == value) return this;
    MathContext newValue = Objects.requireNonNull(value, "mathContext");
    return new ImmutableExpression(newValue, this.zoneId, this.source, this.root);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Expression#zoneId() zoneId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpression withZoneId(ZoneId value) {
    if (this.zoneId == value) return this;
    ZoneId newValue = Objects.requireNonNull(value, "zoneId");
    return new ImmutableExpression(this.mathContext, newValue, this.source, this.root);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Expression#source() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpression withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableExpression(this.mathContext, this.zoneId, newValue, this.root);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Expression#root() root} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for root
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpression withRoot(Node value) {
    if (this.root == value) return this;
    Node newValue = Objects.requireNonNull(value, "root");
    return new ImmutableExpression(this.mathContext, this.zoneId, this.source, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExpression} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExpression
        && equalTo(0, (ImmutableExpression) another);
  }

  private boolean equalTo(int synthetic, ImmutableExpression another) {
    return mathContext.equals(another.mathContext)
        && zoneId.equals(another.zoneId)
        && source.equals(another.source)
        && root.equals(another.root)
        && variables.equals(another.variables)
        && usedVariables.equals(another.usedVariables);
  }

  /**
   * Computes a hash code from attributes: {@code mathContext}, {@code zoneId}, {@code source}, {@code root}, {@code variables}, {@code usedVariables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + mathContext.hashCode();
    h += (h << 5) + zoneId.hashCode();
    h += (h << 5) + source.hashCode();
    h += (h << 5) + root.hashCode();
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + usedVariables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Expression} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Expression{"
        + "mathContext=" + mathContext
        + ", zoneId=" + zoneId
        + ", source=" + source
        + ", root=" + root
        + ", variables=" + variables
        + ", usedVariables=" + usedVariables
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long USED_VARIABLES_WITH_HASH_LAZY_INIT_BIT = 0x1L;

  private transient Map<String, Integer> usedVariablesWithHash;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Expression#usedVariablesWithHash() usedVariablesWithHash} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code usedVariablesWithHash} attribute
   */
  @Override
  public Map<String, Integer> usedVariablesWithHash() {
    if ((lazyInitBitmap & USED_VARIABLES_WITH_HASH_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & USED_VARIABLES_WITH_HASH_LAZY_INIT_BIT) == 0) {
          this.usedVariablesWithHash = Objects.requireNonNull(super.usedVariablesWithHash(), "usedVariablesWithHash");
          lazyInitBitmap |= USED_VARIABLES_WITH_HASH_LAZY_INIT_BIT;
        }
      }
    }
    return usedVariablesWithHash;
  }

  /**
   * Creates an immutable copy of a {@link Expression} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Expression instance
   */
  public static ImmutableExpression copyOf(Expression instance) {
    if (instance instanceof ImmutableExpression) {
      return (ImmutableExpression) instance;
    }
    return ImmutableExpression.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExpression ImmutableExpression}.
   * <pre>
   * ImmutableExpression.builder()
   *    .mathContext(java.math.MathContext) // required {@link Expression#mathContext() mathContext}
   *    .zoneId(java.time.ZoneId) // required {@link Expression#zoneId() zoneId}
   *    .source(String) // required {@link Expression#source() source}
   *    .root(de.flapdoodle.eval.core.tree.Node) // required {@link Expression#root() root}
   *    .build();
   * </pre>
   * @return A new ImmutableExpression builder
   */
  public static ImmutableExpression.Builder builder() {
    return new ImmutableExpression.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExpression ImmutableExpression}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Expression", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_MATH_CONTEXT = 0x1L;
    private static final long INIT_BIT_ZONE_ID = 0x2L;
    private static final long INIT_BIT_SOURCE = 0x4L;
    private static final long INIT_BIT_ROOT = 0x8L;
    private long initBits = 0xfL;

    private MathContext mathContext;
    private ZoneId zoneId;
    private String source;
    private Node root;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Expression} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Expression instance) {
      Objects.requireNonNull(instance, "instance");
      this.mathContext(instance.mathContext());
      this.zoneId(instance.zoneId());
      this.source(instance.source());
      this.root(instance.root());
      return this;
    }

    /**
     * Initializes the value for the {@link Expression#mathContext() mathContext} attribute.
     * @param mathContext The value for mathContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mathContext(MathContext mathContext) {
      this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
      initBits &= ~INIT_BIT_MATH_CONTEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link Expression#zoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(ZoneId zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Expression#source() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the value for the {@link Expression#root() root} attribute.
     * @param root The value for root 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder root(Node root) {
      this.root = Objects.requireNonNull(root, "root");
      initBits &= ~INIT_BIT_ROOT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExpression ImmutableExpression}.
     * @return An immutable instance of Expression
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExpression build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExpression(mathContext, zoneId, source, root);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MATH_CONTEXT) != 0) attributes.add("mathContext");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      if ((initBits & INIT_BIT_ROOT) != 0) attributes.add("root");
      return "Cannot build Expression, some of required attributes are not set " + attributes;
    }
  }
}
