package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.Nullable;
import de.flapdoodle.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Evaluated}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvaluated.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableEvaluated.of()}.
 */
@Generated(from = "Evaluated", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEvaluated<T> extends Evaluated<T> {
  private final TypeInfo<T> type;
  private final @Nullable T wrapped;
  private transient final boolean isNull;

  private ImmutableEvaluated(TypeInfo<T> type, @Nullable T wrapped) {
    this.type = Objects.requireNonNull(type, "type");
    this.wrapped = wrapped;
    this.isNull = super.isNull();
  }

  private ImmutableEvaluated(
      ImmutableEvaluated<T> original,
      TypeInfo<T> type,
      @Nullable T wrapped) {
    this.type = type;
    this.wrapped = wrapped;
    this.isNull = super.isNull();
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public TypeInfo<T> type() {
    return type;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public @Nullable T wrapped() {
    return wrapped;
  }

  /**
   * @return The computed-at-construction value of the {@code isNull} attribute
   */
  @Override
  public boolean isNull() {
    return isNull;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Evaluated#type() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluated<T> withType(TypeInfo<T> value) {
    if (this.type == value) return this;
    TypeInfo<T> newValue = Objects.requireNonNull(value, "type");
    return new ImmutableEvaluated<>(this, newValue, this.wrapped);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Evaluated#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluated<T> withWrapped(@Nullable T value) {
    if (this.wrapped == value) return this;
    return new ImmutableEvaluated<>(this, this.type, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvaluated} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvaluated<?>
        && equalTo(0, (ImmutableEvaluated<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvaluated<?> another) {
    return type.equals(another.type)
        && Objects.equals(wrapped, another.wrapped)
        && isNull == another.isNull;
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code wrapped}, {@code isNull}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(wrapped);
    h += (h << 5) + Boolean.hashCode(isNull);
    return h;
  }

  /**
   * Prints the immutable value {@code Evaluated} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Evaluated{"
        + "type=" + type
        + ", wrapped=" + wrapped
        + ", isNull=" + isNull
        + "}";
  }

  /**
   * Construct a new immutable {@code Evaluated} instance.
 * @param <T> generic parameter T
   * @param type The value for the {@code type} attribute
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable Evaluated instance
   */
  public static <T> ImmutableEvaluated<T> of(TypeInfo<T> type, @Nullable T wrapped) {
    return new ImmutableEvaluated<>(type, wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Evaluated} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Evaluated instance
   */
  public static <T> ImmutableEvaluated<T> copyOf(Evaluated<T> instance) {
    if (instance instanceof ImmutableEvaluated<?>) {
      return (ImmutableEvaluated<T>) instance;
    }
    return ImmutableEvaluated.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvaluated ImmutableEvaluated}.
   * <pre>
   * ImmutableEvaluated.&amp;lt;T&amp;gt;builder()
   *    .type(de.flapdoodle.reflection.TypeInfo&amp;lt;T&amp;gt;) // required {@link Evaluated#type() type}
   *    .wrapped(T | null) // nullable {@link Evaluated#wrapped() wrapped}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableEvaluated builder
   */
  public static <T> ImmutableEvaluated.Builder<T> builder() {
    return new ImmutableEvaluated.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableEvaluated ImmutableEvaluated}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Evaluated", generator = "Immutables")
  public static final class Builder<T> {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private TypeInfo<T> type;
    private T wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Evaluated} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Evaluated<T> instance) {
      Objects.requireNonNull(instance, "instance");
      this.type(instance.type());
      @Nullable T wrappedValue = instance.wrapped();
      if (wrappedValue != null) {
        wrapped(wrappedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Evaluated#type() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> type(TypeInfo<T> type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link Evaluated#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> wrapped(@Nullable T wrapped) {
      this.wrapped = wrapped;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvaluated ImmutableEvaluated}.
     * @return An immutable instance of Evaluated
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvaluated<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEvaluated<>(null, type, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build Evaluated, some of required attributes are not set " + attributes;
    }
  }
}
