/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.ImmutableExpression;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.VariableTypeResolver;
import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.exceptions.ParseException;
import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.eval.core.tree.Variables;
import de.flapdoodle.reflection.TypeInfo;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Expression {
    protected abstract MathContext mathContext();

    protected abstract ZoneId zoneId();

    public abstract String source();

    public abstract Node root();

    @Value.Auxiliary
    public Evaluated<?> evaluate(VariableResolver variableResolver) throws EvaluationException, ParseException {
        return this.root().evaluate(variableResolver, EvaluationContext.builder().mathContext(this.mathContext()).zoneId(this.zoneId()).build());
    }

    @Value.Auxiliary
    public TypeInfo<?> evaluateType(VariableTypeResolver variableResolver) throws EvaluationException {
        return this.root().evaluateType(variableResolver);
    }

    @Value.Derived
    public Variables variables() {
        return Node.hashedUsedVariables(this.source(), this.root());
    }

    @Value.Lazy
    public Map<String, Integer> usedVariablesWithHash() {
        return this.variables().nameHashMap();
    }

    @Value.Derived
    public Set<String> usedVariables() {
        return this.variables().names();
    }

    @Value.Auxiliary
    public Set<String> undefinedVariables(VariableResolver variableResolver) {
        return this.usedVariables().stream().filter(name -> !variableResolver.has((String)name)).collect(Collectors.toSet());
    }

    @Value.Auxiliary
    public List<Node> allNodes() {
        return Node.allNodes(this.root());
    }

    public static ImmutableExpression.Builder builder() {
        return ImmutableExpression.builder();
    }
}

