/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.Expression;
import de.flapdoodle.eval.core.ImmutableExpressionFactory;
import de.flapdoodle.eval.core.MapBasedVariableResolver;
import de.flapdoodle.eval.core.NumberAsValue;
import de.flapdoodle.eval.core.StringAsValue;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.OperatorMap;
import de.flapdoodle.eval.core.evaluables.OperatorMapping;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByName;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.exceptions.ParseException;
import de.flapdoodle.eval.core.parser.ASTNode;
import de.flapdoodle.eval.core.parser.ShuntingYardConverter;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.parser.Tokenizer;
import de.flapdoodle.eval.core.tree.EvaluableExceptionMapper;
import de.flapdoodle.eval.core.tree.EvaluatableNode;
import de.flapdoodle.eval.core.tree.LookupNode;
import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.eval.core.tree.ValueNode;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ExpressionFactory {
    @Value.Default
    public MathContext mathContext() {
        return MathContext.DECIMAL128;
    }

    @Value.Default
    protected ZoneId zoneId() {
        return ZoneId.systemDefault();
    }

    public abstract VariableResolver constants();

    public abstract TypedEvaluableByName evaluatables();

    protected abstract TypedEvaluableByNumberOfArguments arrayAccess();

    protected abstract TypedEvaluableByNumberOfArguments propertyAccess();

    protected abstract NumberAsValue numberAsValue();

    protected abstract StringAsValue stringAsValue();

    protected abstract EvaluableExceptionMapper exceptionMapper();

    public abstract OperatorMap operatorMap();

    @Value.Auxiliary
    public final ImmutableExpressionFactory withConstant(String name, Evaluated<?> value) {
        return ImmutableExpressionFactory.copyOf(this).withConstants(MapBasedVariableResolver.empty().with(name, value).andThen(this.constants()));
    }

    @Value.Auxiliary
    public Expression parse(String expression) throws ParseException, EvaluationException {
        Node node = this.map(this.abstractSyntaxTree(expression));
        return Expression.builder().mathContext(this.mathContext()).zoneId(this.zoneId()).root(node).source(expression).build();
    }

    @Value.Auxiliary
    public ASTNode abstractSyntaxTree(String expression) throws ParseException {
        return new ShuntingYardConverter(expression, this.tokens(expression), this.operatorMap(), this.evaluatables()).toAbstractSyntaxTree();
    }

    @Value.Auxiliary
    public List<Token> tokens(String expression) throws ParseException {
        return new Tokenizer(expression, this.operatorMap()).parse();
    }

    @Value.Auxiliary
    protected Node map(ASTNode startNode) throws EvaluationException {
        ValueNode<Object> result;
        Token token = startNode.getToken();
        switch (token.type()) {
            case NUMBER_LITERAL: {
                result = ValueNode.of(token, Evaluated.value(this.numberAsValue().parse(token.value(), this.mathContext())));
                break;
            }
            case STRING_LITERAL: {
                result = ValueNode.of(token, Evaluated.value(this.stringAsValue().parse(token.value())));
                break;
            }
            case VARIABLE_OR_CONSTANT: {
                result = this.getVariableOrConstant(token);
                break;
            }
            case PREFIX_OPERATOR: {
                result = this.prefixOperator(startNode, token);
                break;
            }
            case POSTFIX_OPERATOR: {
                result = this.postfixOperator(startNode, token);
                break;
            }
            case INFIX_OPERATOR: {
                result = this.infixOperator(startNode, token);
                break;
            }
            case ARRAY_INDEX: {
                result = this.evaluateArrayIndex(startNode);
                break;
            }
            case STRUCTURE_SEPARATOR: {
                result = this.evaluateStructureSeparator(startNode);
                break;
            }
            case FUNCTION: {
                result = this.evaluateFunction(startNode, token);
                break;
            }
            default: {
                throw new EvaluationException(token, "Unexpected evaluation token: " + token);
            }
        }
        return result;
    }

    private Node postfixOperator(ASTNode startNode, Token token) throws EvaluationException {
        List<Node> parameters = Arrays.asList(this.map(startNode.getParameters().get(0)));
        Optional<OperatorMapping> operatorMapping = this.operatorMap().postfixOperator(token.value());
        if (!operatorMapping.isPresent()) {
            throw new EvaluationException(token, "could not find postfix operator");
        }
        return this.evaluatableNode(token, operatorMapping.get(), parameters);
    }

    private EvaluatableNode evaluatableNode(Token token, OperatorMapping operatorMapping, List<Node> parameters) {
        Optional<? extends TypedEvaluableByArguments> evaluatable = this.evaluatables().find(operatorMapping.evaluatable(), parameters.size());
        if (evaluatable.isPresent()) {
            return EvaluatableNode.of(token, evaluatable.get(), parameters, this.exceptionMapper());
        }
        throw new RuntimeException("could not find evaluatable for " + operatorMapping);
    }

    private Node infixOperator(ASTNode startNode, Token token) throws EvaluationException {
        Node first = this.map(startNode.getParameters().get(0));
        Node second = this.map(startNode.getParameters().get(1));
        List<Node> parameters = Arrays.asList(first, second);
        Optional<OperatorMapping> operatorMapping = this.operatorMap().infixOperator(token.value());
        if (!operatorMapping.isPresent()) {
            throw new EvaluationException(token, "could not find infix operator");
        }
        return this.evaluatableNode(token, operatorMapping.get(), parameters);
    }

    private Node prefixOperator(ASTNode startNode, Token token) throws EvaluationException {
        List<Node> parameters = Arrays.asList(this.map(startNode.getParameters().get(0)));
        Optional<OperatorMapping> operatorMapping = this.operatorMap().prefixOperator(token.value());
        if (!operatorMapping.isPresent()) {
            throw new EvaluationException(token, "could not find prefix operator");
        }
        return this.evaluatableNode(token, operatorMapping.get(), parameters);
    }

    private Node getVariableOrConstant(Token token) {
        Evaluated<?> result = this.constants().get(token.value());
        if (result != null) {
            return ValueNode.of(token, result);
        }
        return LookupNode.of(token);
    }

    private Node evaluateFunction(ASTNode startNode, Token token) throws EvaluationException {
        ArrayList<Node> parameterResults = new ArrayList<Node>();
        for (int i = 0; i < startNode.getParameters().size(); ++i) {
            parameterResults.add(this.map(startNode.getParameters().get(i)));
        }
        Optional<? extends TypedEvaluableByArguments> evaluatable = this.evaluatables().find(token.value(), startNode.getParameters().size());
        if (!evaluatable.isPresent()) {
            throw new EvaluationException(token, "could not find evaluatable");
        }
        return EvaluatableNode.of(token, evaluatable.get(), parameterResults, this.exceptionMapper());
    }

    private Node evaluateArrayIndex(ASTNode startNode) throws EvaluationException {
        Node objectNode = this.map(startNode.getParameters().get(0));
        Node indexNode = this.map(startNode.getParameters().get(1));
        Optional<? extends TypedEvaluableByArguments> arrayAccess = this.arrayAccess().filterByNumberOfArguments(2);
        if (!arrayAccess.isPresent()) {
            throw new EvaluationException(startNode.getToken(), "could not find array access");
        }
        return EvaluatableNode.of(startNode.getToken(), arrayAccess.get(), Arrays.asList(objectNode, indexNode), this.exceptionMapper());
    }

    private Node evaluateStructureSeparator(ASTNode startNode) throws EvaluationException {
        Node structure = this.map(startNode.getParameters().get(0));
        Token nameToken = startNode.getParameters().get(1).getToken();
        ValueNode<Object> name = ValueNode.of(nameToken, Evaluated.value(this.stringAsValue().parse(nameToken.value())));
        Optional<? extends TypedEvaluableByArguments> propertyAccess = this.propertyAccess().filterByNumberOfArguments(2);
        if (!propertyAccess.isPresent()) {
            throw new EvaluationException(startNode.getToken(), "could not find property access");
        }
        return EvaluatableNode.of(startNode.getToken(), propertyAccess.get(), Arrays.asList(structure, name), this.exceptionMapper());
    }

    public static ImmutableExpressionFactory.Builder builder() {
        return ImmutableExpressionFactory.builder();
    }
}

