/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.EvaluationContext;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="EvaluationContext", generator="Immutables")
public final class ImmutableEvaluationContext
implements EvaluationContext {
    private final MathContext mathContext;
    private final ZoneId zoneId;

    private ImmutableEvaluationContext(MathContext mathContext, ZoneId zoneId) {
        this.mathContext = mathContext;
        this.zoneId = zoneId;
    }

    @Override
    public MathContext mathContext() {
        return this.mathContext;
    }

    @Override
    public ZoneId zoneId() {
        return this.zoneId;
    }

    public final ImmutableEvaluationContext withMathContext(MathContext value) {
        if (this.mathContext == value) {
            return this;
        }
        MathContext newValue = Objects.requireNonNull(value, "mathContext");
        return new ImmutableEvaluationContext(newValue, this.zoneId);
    }

    public final ImmutableEvaluationContext withZoneId(ZoneId value) {
        if (this.zoneId == value) {
            return this;
        }
        ZoneId newValue = Objects.requireNonNull(value, "zoneId");
        return new ImmutableEvaluationContext(this.mathContext, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvaluationContext && this.equalTo(0, (ImmutableEvaluationContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableEvaluationContext another) {
        return this.mathContext.equals(another.mathContext) && this.zoneId.equals(another.zoneId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mathContext.hashCode();
        h += (h << 5) + this.zoneId.hashCode();
        return h;
    }

    public String toString() {
        return "EvaluationContext{mathContext=" + this.mathContext + ", zoneId=" + this.zoneId + "}";
    }

    public static ImmutableEvaluationContext copyOf(EvaluationContext instance) {
        if (instance instanceof ImmutableEvaluationContext) {
            return (ImmutableEvaluationContext)instance;
        }
        return ImmutableEvaluationContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EvaluationContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MATH_CONTEXT = 1L;
        private static final long INIT_BIT_ZONE_ID = 2L;
        private long initBits = 3L;
        private MathContext mathContext;
        private ZoneId zoneId;

        private Builder() {
        }

        public final Builder from(EvaluationContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.mathContext(instance.mathContext());
            this.zoneId(instance.zoneId());
            return this;
        }

        public final Builder mathContext(MathContext mathContext) {
            this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder zoneId(ZoneId zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableEvaluationContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEvaluationContext(this.mathContext, this.zoneId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mathContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("zoneId");
            }
            return "Cannot build EvaluationContext, some of required attributes are not set " + attributes;
        }
    }
}

