/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.Expression;
import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.eval.core.tree.Variables;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="Expression", generator="Immutables")
public final class ImmutableExpression
extends Expression {
    private final MathContext mathContext;
    private final ZoneId zoneId;
    private final String source;
    private final Node root;
    private final transient Variables variables;
    private final transient Set<String> usedVariables;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long USED_VARIABLES_WITH_HASH_LAZY_INIT_BIT = 1L;
    private transient Map<String, Integer> usedVariablesWithHash;

    private ImmutableExpression(MathContext mathContext, ZoneId zoneId, String source, Node root) {
        this.mathContext = mathContext;
        this.zoneId = zoneId;
        this.source = source;
        this.root = root;
        this.variables = this.initShim.variables();
        this.usedVariables = this.initShim.usedVariables();
        this.initShim = null;
    }

    @Override
    protected MathContext mathContext() {
        return this.mathContext;
    }

    @Override
    protected ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public Node root() {
        return this.root;
    }

    @Override
    public Variables variables() {
        InitShim shim = this.initShim;
        return shim != null ? shim.variables() : this.variables;
    }

    @Override
    public Set<String> usedVariables() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usedVariables() : this.usedVariables;
    }

    public final ImmutableExpression withMathContext(MathContext value) {
        if (this.mathContext == value) {
            return this;
        }
        MathContext newValue = Objects.requireNonNull(value, "mathContext");
        return new ImmutableExpression(newValue, this.zoneId, this.source, this.root);
    }

    public final ImmutableExpression withZoneId(ZoneId value) {
        if (this.zoneId == value) {
            return this;
        }
        ZoneId newValue = Objects.requireNonNull(value, "zoneId");
        return new ImmutableExpression(this.mathContext, newValue, this.source, this.root);
    }

    public final ImmutableExpression withSource(String value) {
        String newValue = Objects.requireNonNull(value, "source");
        if (this.source.equals(newValue)) {
            return this;
        }
        return new ImmutableExpression(this.mathContext, this.zoneId, newValue, this.root);
    }

    public final ImmutableExpression withRoot(Node value) {
        if (this.root == value) {
            return this;
        }
        Node newValue = Objects.requireNonNull(value, "root");
        return new ImmutableExpression(this.mathContext, this.zoneId, this.source, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExpression && this.equalTo(0, (ImmutableExpression)another);
    }

    private boolean equalTo(int synthetic, ImmutableExpression another) {
        return this.mathContext.equals(another.mathContext) && this.zoneId.equals(another.zoneId) && this.source.equals(another.source) && this.root.equals(another.root) && this.variables.equals(another.variables) && this.usedVariables.equals(another.usedVariables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mathContext.hashCode();
        h += (h << 5) + this.zoneId.hashCode();
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + this.usedVariables.hashCode();
        return h;
    }

    public String toString() {
        return "Expression{mathContext=" + this.mathContext + ", zoneId=" + this.zoneId + ", source=" + this.source + ", root=" + this.root + ", variables=" + this.variables + ", usedVariables=" + this.usedVariables + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> usedVariablesWithHash() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableExpression immutableExpression = this;
            synchronized (immutableExpression) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.usedVariablesWithHash = Objects.requireNonNull(super.usedVariablesWithHash(), "usedVariablesWithHash");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.usedVariablesWithHash;
    }

    public static ImmutableExpression copyOf(Expression instance) {
        if (instance instanceof ImmutableExpression) {
            return (ImmutableExpression)instance;
        }
        return ImmutableExpression.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Expression", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MATH_CONTEXT = 1L;
        private static final long INIT_BIT_ZONE_ID = 2L;
        private static final long INIT_BIT_SOURCE = 4L;
        private static final long INIT_BIT_ROOT = 8L;
        private long initBits = 15L;
        private MathContext mathContext;
        private ZoneId zoneId;
        private String source;
        private Node root;

        private Builder() {
        }

        public final Builder from(Expression instance) {
            Objects.requireNonNull(instance, "instance");
            this.mathContext(instance.mathContext());
            this.zoneId(instance.zoneId());
            this.source(instance.source());
            this.root(instance.root());
            return this;
        }

        public final Builder mathContext(MathContext mathContext) {
            this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder zoneId(ZoneId zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder source(String source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder root(Node root) {
            this.root = Objects.requireNonNull(root, "root");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableExpression build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExpression(this.mathContext, this.zoneId, this.source, this.root);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mathContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("zoneId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("root");
            }
            return "Cannot build Expression, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Expression", generator="Immutables")
    private final class InitShim {
        private byte variablesBuildStage = 0;
        private Variables variables;
        private byte usedVariablesBuildStage = 0;
        private Set<String> usedVariables;

        private InitShim() {
        }

        Variables variables() {
            if (this.variablesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.variablesBuildStage == 0) {
                this.variablesBuildStage = (byte)-1;
                this.variables = Objects.requireNonNull(ImmutableExpression.super.variables(), "variables");
                this.variablesBuildStage = 1;
            }
            return this.variables;
        }

        Set<String> usedVariables() {
            if (this.usedVariablesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usedVariablesBuildStage == 0) {
                this.usedVariablesBuildStage = (byte)-1;
                this.usedVariables = Objects.requireNonNull(ImmutableExpression.super.usedVariables(), "usedVariables");
                this.usedVariablesBuildStage = 1;
            }
            return this.usedVariables;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.variablesBuildStage == -1) {
                attributes.add("variables");
            }
            if (this.usedVariablesBuildStage == -1) {
                attributes.add("usedVariables");
            }
            return "Cannot build Expression, attribute initializers form cycle " + attributes;
        }
    }
}

