/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.MapBasedVariableResolver;
import de.flapdoodle.eval.core.evaluables.Evaluated;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MapBasedVariableResolver", generator="Immutables")
public final class ImmutableMapBasedVariableResolver
extends MapBasedVariableResolver {
    private final Map<String, Evaluated<?>> variables;

    private ImmutableMapBasedVariableResolver(Map<String, Evaluated<?>> variables) {
        this.variables = variables;
    }

    @Override
    protected Map<String, Evaluated<?>> variables() {
        return this.variables;
    }

    public final ImmutableMapBasedVariableResolver withVariables(Map<String, ? extends Evaluated<?>> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Evaluated<?>> newValue = ImmutableMapBasedVariableResolver.createUnmodifiableMap(true, false, entries);
        return new ImmutableMapBasedVariableResolver(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMapBasedVariableResolver && this.equalTo(0, (ImmutableMapBasedVariableResolver)another);
    }

    private boolean equalTo(int synthetic, ImmutableMapBasedVariableResolver another) {
        return this.variables.equals(another.variables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        return h;
    }

    public String toString() {
        return "MapBasedVariableResolver{variables=" + this.variables + "}";
    }

    public static ImmutableMapBasedVariableResolver copyOf(MapBasedVariableResolver instance) {
        if (instance instanceof ImmutableMapBasedVariableResolver) {
            return (ImmutableMapBasedVariableResolver)instance;
        }
        return ImmutableMapBasedVariableResolver.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="MapBasedVariableResolver", generator="Immutables")
    public static final class Builder {
        private Map<String, Evaluated<?>> variables = new LinkedHashMap();

        private Builder() {
        }

        public final Builder from(MapBasedVariableResolver instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllVariables(instance.variables());
            return this;
        }

        public final Builder putVariables(String key, Evaluated<?> value) {
            this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, value == null ? "variables value for key: " + key : null));
            return this;
        }

        public final Builder putVariables(Map.Entry<String, ? extends Evaluated<?>> entry) {
            String k = entry.getKey();
            Evaluated<?> v = entry.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, v == null ? "variables value for key: " + k : null));
            return this;
        }

        public final Builder variables(Map<String, ? extends Evaluated<?>> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Evaluated<?>> entries) {
            for (Map.Entry<String, Evaluated<?>> e : entries.entrySet()) {
                String k = e.getKey();
                Evaluated<?> v = e.getValue();
                this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, v == null ? "variables value for key: " + k : null));
            }
            return this;
        }

        public ImmutableMapBasedVariableResolver build() {
            return new ImmutableMapBasedVariableResolver(ImmutableMapBasedVariableResolver.createUnmodifiableMap(false, false, this.variables));
        }
    }
}

