/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.evaluables.Signature;
import de.flapdoodle.reflection.TypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Signature", generator="Immutables")
public final class ImmutableSignature<T>
extends Signature<T> {
    private final List<Parameter<?>> parameters;
    private final boolean isVarArg;
    private final TypeInfo<T> returnType;
    private final transient int minNumberOfArguments;
    private final transient int maxNumberOfArguments;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSignature(Builder<T> builder) {
        this.parameters = ImmutableSignature.createUnmodifiableList(true, ((Builder)builder).parameters);
        this.returnType = ((Builder)builder).returnType;
        if (((Builder)builder).isVarArgIsSet()) {
            this.initShim.isVarArg(((Builder)builder).isVarArg);
        }
        this.isVarArg = this.initShim.isVarArg();
        this.minNumberOfArguments = this.initShim.minNumberOfArguments();
        this.maxNumberOfArguments = this.initShim.maxNumberOfArguments();
        this.initShim = null;
    }

    private ImmutableSignature(List<Parameter<?>> parameters, boolean isVarArg, TypeInfo<T> returnType) {
        this.parameters = parameters;
        this.initShim.isVarArg(isVarArg);
        this.returnType = returnType;
        this.isVarArg = this.initShim.isVarArg();
        this.minNumberOfArguments = this.initShim.minNumberOfArguments();
        this.maxNumberOfArguments = this.initShim.maxNumberOfArguments();
        this.initShim = null;
    }

    @Override
    public List<Parameter<?>> parameters() {
        return this.parameters;
    }

    @Override
    public boolean isVarArg() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isVarArg() : this.isVarArg;
    }

    @Override
    public TypeInfo<T> returnType() {
        return this.returnType;
    }

    @Override
    public int minNumberOfArguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minNumberOfArguments() : this.minNumberOfArguments;
    }

    @Override
    public int maxNumberOfArguments() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxNumberOfArguments() : this.maxNumberOfArguments;
    }

    @SafeVarargs
    public final ImmutableSignature<T> withParameters(Parameter<?> ... elements) {
        List<Parameter<?>> newValue = ImmutableSignature.createUnmodifiableList(false, ImmutableSignature.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSignature<T>(newValue, this.isVarArg, this.returnType);
    }

    public final ImmutableSignature<T> withParameters(Iterable<? extends Parameter<?>> elements) {
        if (this.parameters == elements) {
            return this;
        }
        List<Parameter<?>> newValue = ImmutableSignature.createUnmodifiableList(false, ImmutableSignature.createSafeList(elements, true, false));
        return new ImmutableSignature<T>(newValue, this.isVarArg, this.returnType);
    }

    public final ImmutableSignature<T> withIsVarArg(boolean value) {
        if (this.isVarArg == value) {
            return this;
        }
        return new ImmutableSignature<T>(this.parameters, value, this.returnType);
    }

    public final ImmutableSignature<T> withReturnType(TypeInfo<T> value) {
        if (this.returnType == value) {
            return this;
        }
        TypeInfo<T> newValue = Objects.requireNonNull(value, "returnType");
        return new ImmutableSignature<T>(this.parameters, this.isVarArg, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignature && this.equalTo(0, (ImmutableSignature)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignature<?> another) {
        return this.parameters.equals(another.parameters) && this.isVarArg == another.isVarArg && this.returnType.equals(another.returnType) && this.minNumberOfArguments == another.minNumberOfArguments && this.maxNumberOfArguments == another.maxNumberOfArguments;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parameters.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isVarArg);
        h += (h << 5) + this.returnType.hashCode();
        h += (h << 5) + this.minNumberOfArguments;
        h += (h << 5) + this.maxNumberOfArguments;
        return h;
    }

    public String toString() {
        return "Signature{parameters=" + this.parameters + ", isVarArg=" + this.isVarArg + ", returnType=" + this.returnType + ", minNumberOfArguments=" + this.minNumberOfArguments + ", maxNumberOfArguments=" + this.maxNumberOfArguments + "}";
    }

    public static <T> ImmutableSignature<T> copyOf(Signature<T> instance) {
        if (instance instanceof ImmutableSignature) {
            return (ImmutableSignature)instance;
        }
        return ImmutableSignature.builder().from(instance).build();
    }

    public static <T> Builder<T> builder(TypeInfo<T> returnType) {
        return new Builder(returnType);
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Signature", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_RETURN_TYPE = 1L;
        private static final long OPT_BIT_IS_VAR_ARG = 1L;
        private long initBits = 1L;
        private long optBits;
        private List<Parameter<?>> parameters = new ArrayList();
        private boolean isVarArg;
        private TypeInfo<T> returnType;

        private Builder(TypeInfo<T> returnType) {
            this.returnType(returnType);
        }

        private Builder() {
        }

        public final Builder<T> from(Signature<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllParameters(instance.parameters());
            this.isVarArg(instance.isVarArg());
            this.returnType(instance.returnType());
            return this;
        }

        public final Builder<T> addParameters(Parameter<?> element) {
            this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            return this;
        }

        @SafeVarargs
        public final Builder<T> addParameters(Parameter<?> ... elements) {
            for (Parameter<?> element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            return this;
        }

        public final Builder<T> parameters(Iterable<? extends Parameter<?>> elements) {
            this.parameters.clear();
            return this.addAllParameters(elements);
        }

        public final Builder<T> addAllParameters(Iterable<? extends Parameter<?>> elements) {
            for (Parameter<?> element : elements) {
                this.parameters.add(Objects.requireNonNull(element, "parameters element"));
            }
            return this;
        }

        public final Builder<T> isVarArg(boolean isVarArg) {
            this.isVarArg = isVarArg;
            this.optBits |= 1L;
            return this;
        }

        final Builder<T> returnType(TypeInfo<T> returnType) {
            this.returnType = Objects.requireNonNull(returnType, "returnType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSignature<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSignature(this);
        }

        private boolean isVarArgIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("returnType");
            }
            return "Cannot build Signature, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Signature", generator="Immutables")
    private final class InitShim {
        private byte isVarArgBuildStage = 0;
        private boolean isVarArg;
        private byte minNumberOfArgumentsBuildStage = 0;
        private int minNumberOfArguments;
        private byte maxNumberOfArgumentsBuildStage = 0;
        private int maxNumberOfArguments;

        private InitShim() {
        }

        boolean isVarArg() {
            if (this.isVarArgBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isVarArgBuildStage == 0) {
                this.isVarArgBuildStage = (byte)-1;
                this.isVarArg = ImmutableSignature.super.isVarArg();
                this.isVarArgBuildStage = 1;
            }
            return this.isVarArg;
        }

        void isVarArg(boolean isVarArg) {
            this.isVarArg = isVarArg;
            this.isVarArgBuildStage = 1;
        }

        int minNumberOfArguments() {
            if (this.minNumberOfArgumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minNumberOfArgumentsBuildStage == 0) {
                this.minNumberOfArgumentsBuildStage = (byte)-1;
                this.minNumberOfArguments = ImmutableSignature.super.minNumberOfArguments();
                this.minNumberOfArgumentsBuildStage = 1;
            }
            return this.minNumberOfArguments;
        }

        int maxNumberOfArguments() {
            if (this.maxNumberOfArgumentsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxNumberOfArgumentsBuildStage == 0) {
                this.maxNumberOfArgumentsBuildStage = (byte)-1;
                this.maxNumberOfArguments = ImmutableSignature.super.maxNumberOfArguments();
                this.maxNumberOfArgumentsBuildStage = 1;
            }
            return this.maxNumberOfArguments;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isVarArgBuildStage == -1) {
                attributes.add("isVarArg");
            }
            if (this.minNumberOfArgumentsBuildStage == -1) {
                attributes.add("minNumberOfArguments");
            }
            if (this.maxNumberOfArgumentsBuildStage == -1) {
                attributes.add("maxNumberOfArguments");
            }
            return "Cannot build Signature, attribute initializers form cycle " + attributes;
        }
    }
}

