/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.ImmutableSignature;
import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.reflection.TypeInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.builder.Builder;
import org.immutables.value.Value;

@Value.Immutable
public abstract class Signature<T> {
    public abstract List<Parameter<?>> parameters();

    @Value.Default
    public boolean isVarArg() {
        return false;
    }

    @Builder.Parameter
    public abstract TypeInfo<T> returnType();

    @Value.Derived
    public int minNumberOfArguments() {
        return this.parameters().size();
    }

    @Value.Derived
    public int maxNumberOfArguments() {
        return this.isVarArg() ? Integer.MAX_VALUE : this.parameters().size();
    }

    @Value.Auxiliary
    public String asHumanReadable() {
        return "" + this.returnType() + "(" + (this.isVarArg() ? "vararg " : "") + this.parameters().stream().map(it -> it.type().toString() + (it.isNullable() ? "?" : "")).collect(Collectors.joining(", ")) + ")";
    }

    @Value.Auxiliary
    public Parameter<?> get(int index) {
        if (this.isVarArg() && index >= this.parameters().size()) {
            index = this.parameters().size() - 1;
        }
        return this.parameters().get(index);
    }

    @Value.Auxiliary
    public Optional<EvaluableException> validateArguments(List<? extends Evaluated<?>> arguments) {
        Optional<EvaluableException> error;
        if (this.minNumberOfArguments() > arguments.size()) {
            return Optional.of(EvaluableException.of("not enough(<%s) arguments: %s", this.minNumberOfArguments(), arguments.size()));
        }
        if (arguments.size() > this.maxNumberOfArguments()) {
            return Optional.of(EvaluableException.of("to many(>%s) arguments: ", this.maxNumberOfArguments(), arguments.size()));
        }
        for (int i = 0; i < this.minNumberOfArguments(); ++i) {
            Evaluated<?> value = arguments.get(i);
            Parameter<?> parameter = this.get(i);
            TypeInfo<?> type = parameter.type();
            if (parameter.isNullable() && value.isNull()) {
                if (!type.isAssignable(value.type())) {
                    return Optional.of(EvaluableException.of("wrong nullable type: %s != %s", type, value.type()));
                }
            } else if (!type.isInstance(value.wrapped())) {
                return Optional.of(EvaluableException.of("wrong type: %s != %s (%s)", type, value.type(), value.wrapped()));
            }
            if (!(error = parameter.validationError(value)).isPresent()) continue;
            return error;
        }
        if (this.isVarArg()) {
            Parameter<?> parameter = this.get(this.minNumberOfArguments() - 1);
            TypeInfo<?> type = parameter.type();
            for (int i = this.minNumberOfArguments(); i < arguments.size(); ++i) {
                Evaluated<?> value = arguments.get(i);
                if (parameter.isNullable() && value.isNull()) {
                    if (!type.isAssignable(value.type())) {
                        return Optional.of(EvaluableException.of("wrong nullable type: %s != %s", type, value.type()));
                    }
                } else if (!type.isInstance(value.wrapped())) {
                    return Optional.of(EvaluableException.of("wrong type: %s != %s (%s)", type, value.getClass(), value));
                }
                if (!(error = parameter.validationError(value)).isPresent()) continue;
                return error;
            }
        }
        return Optional.empty();
    }

    @Value.Auxiliary
    public Optional<EvaluableException> validateArgumentTypes(List<? extends TypeInfo<?>> arguments) {
        if (this.minNumberOfArguments() > arguments.size()) {
            return Optional.of(EvaluableException.of("not enough(<%s) arguments: %s", this.minNumberOfArguments(), arguments.size()));
        }
        if (arguments.size() > this.maxNumberOfArguments()) {
            return Optional.of(EvaluableException.of("to many(>%s) arguments: ", this.maxNumberOfArguments(), arguments.size()));
        }
        for (int i = 0; i < this.minNumberOfArguments(); ++i) {
            TypeInfo<?> valueType = arguments.get(i);
            Parameter<?> parameter = this.get(i);
            TypeInfo<?> type = parameter.type();
            if (type.isAssignable(valueType)) continue;
            return Optional.of(EvaluableException.of("wrong type: %s != %s", type, valueType));
        }
        if (this.isVarArg()) {
            Parameter<?> parameter = this.get(this.minNumberOfArguments() - 1);
            TypeInfo<?> type = parameter.type();
            for (int i = this.minNumberOfArguments(); i < arguments.size(); ++i) {
                TypeInfo<?> valueType = arguments.get(i);
                if (type.isAssignable(valueType)) continue;
                return Optional.of(EvaluableException.of("wrong type: %s != %s", type, valueType));
            }
        }
        return Optional.empty();
    }

    public static <T> Signature<T> of(Class<T> returnType, List<? extends Parameter<?>> parameters) {
        return Signature.of(TypeInfo.of(returnType), parameters);
    }

    public static <T> Signature<T> of(TypeInfo<T> returnType, List<? extends Parameter<?>> parameters) {
        return ImmutableSignature.builder(returnType).addAllParameters(parameters).build();
    }

    public static <T> Signature<T> of(Class<T> returnType, Parameter<?> ... parameters) {
        return Signature.of(TypeInfo.of(returnType), parameters);
    }

    public static <T> Signature<T> of(TypeInfo<T> returnType, Parameter<?> ... parameters) {
        return ImmutableSignature.builder(returnType).addParameters(parameters).build();
    }

    public static <T> Signature<T> ofVarArg(Class<T> returnType, Parameter<?> ... parameters) {
        return Signature.ofVarArg(TypeInfo.of(returnType), parameters);
    }

    public static <T> Signature<T> ofVarArg(TypeInfo<T> returnType, Parameter<?> ... parameters) {
        return ImmutableSignature.builder(returnType).addParameters(parameters).isVarArg(true).build();
    }
}

