/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.ImmutableTypedEvaluables;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Either;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class TypedEvaluables
implements TypedEvaluableByArguments,
TypedEvaluableByNumberOfArguments {
    protected abstract List<TypedEvaluable<?>> list();

    @Override
    @Value.Auxiliary
    public Optional<? extends TypedEvaluableByArguments> filterByNumberOfArguments(int numberOfArguments) {
        List<TypedEvaluable<?>> filtered = TypedEvaluableByNumberOfArguments.filterByNumberOfArguments(this.list(), numberOfArguments);
        return !filtered.isEmpty() ? Optional.of(TypedEvaluables.builder().list(filtered).build()) : Optional.empty();
    }

    @Override
    @Value.Auxiliary
    public Either<TypedEvaluable<?>, EvaluableException> find(List<? extends Evaluated<?>> values) {
        return TypedEvaluableByArguments.find(this.list(), values);
    }

    @Override
    @Value.Auxiliary
    public Either<TypedEvaluable<?>, EvaluableException> findType(List<? extends TypeInfo<?>> valueTypes) {
        return TypedEvaluableByArguments.findType(this.list(), valueTypes);
    }

    public static ImmutableTypedEvaluables.Builder builder() {
        return ImmutableTypedEvaluables.builder();
    }

    public static abstract class Wrapper
    implements TypedEvaluableByNumberOfArguments {
        private final TypedEvaluables delegate;

        public Wrapper(TypedEvaluables delegate) {
            this.delegate = delegate;
        }

        @Override
        public final Optional<? extends TypedEvaluableByArguments> filterByNumberOfArguments(int numberOfArguments) {
            return this.delegate.filterByNumberOfArguments(numberOfArguments);
        }
    }
}

