/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.HasOperator;
import de.flapdoodle.eval.core.evaluables.ImmutableOperatorMap;
import de.flapdoodle.eval.core.evaluables.OperatorMapping;
import de.flapdoodle.eval.core.evaluables.OperatorType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Immutable
public abstract class OperatorMap
implements HasOperator {
    protected abstract Map<String, OperatorMapping> prefix();

    protected abstract Map<String, OperatorMapping> infix();

    protected abstract Map<String, OperatorMapping> postfix();

    @Value.Auxiliary
    public Optional<OperatorMapping> prefixOperator(String name) {
        return Optional.ofNullable(this.prefix().get(name));
    }

    @Value.Auxiliary
    public Optional<OperatorMapping> infixOperator(String name) {
        return Optional.ofNullable(this.infix().get(name));
    }

    @Value.Auxiliary
    public Optional<OperatorMapping> postfixOperator(String name) {
        return Optional.ofNullable(this.postfix().get(name));
    }

    public static ImmutableOperatorMap.Builder builder() {
        return ImmutableOperatorMap.builder();
    }

    public OperatorMap andThen(OperatorMap fallback) {
        return OperatorMap.builder().from(this).putAllInfix(OperatorMap.onlyMissing(fallback.infix(), this.infix().keySet())).putAllPrefix(OperatorMap.onlyMissing(fallback.prefix(), this.prefix().keySet())).putAllPostfix(OperatorMap.onlyMissing(fallback.postfix(), this.postfix().keySet())).build();
    }

    private static <K, V> Map<K, V> onlyMissing(Map<K, V> src, Set<K> exclude) {
        return src.entrySet().stream().filter(e -> !exclude.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public boolean hasStartingWith(OperatorType type, String value) {
        Set<Object> keys = Collections.emptySet();
        switch (type) {
            case Infix: {
                keys = this.infix().keySet();
                break;
            }
            case Prefix: {
                keys = this.prefix().keySet();
                break;
            }
            case Postfix: {
                keys = this.postfix().keySet();
            }
        }
        return keys.stream().anyMatch(it -> it.startsWith(value));
    }

    @Override
    public boolean matching(OperatorType type, String value) {
        switch (type) {
            case Infix: {
                return this.infixOperator(value).isPresent();
            }
            case Prefix: {
                return this.prefixOperator(value).isPresent();
            }
            case Postfix: {
                return this.postfixOperator(value).isPresent();
            }
        }
        return false;
    }
}

