/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.evaluables;

import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.exceptions.EvaluableException;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.types.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface TypedEvaluableByArguments {
    public Either<TypedEvaluable<?>, EvaluableException> find(List<? extends Evaluated<?>> var1);

    public Either<TypedEvaluable<?>, EvaluableException> findType(List<? extends TypeInfo<?>> var1);

    public static Either<TypedEvaluable<?>, EvaluableException> find(List<TypedEvaluable<?>> list, List<? extends Evaluated<?>> values) {
        EvaluableException exception;
        ArrayList<EvaluableException> errors = new ArrayList<EvaluableException>();
        for (TypedEvaluable<?> evaluable : list) {
            Optional<EvaluableException> error = evaluable.signature().validateArguments(values);
            if (error.isPresent()) {
                errors.add(error.get());
                continue;
            }
            return Either.left(evaluable);
        }
        if (errors.size() == 1 && ((EvaluableException)errors.get(0)).isValidationError()) {
            exception = (EvaluableException)errors.get(0);
        } else {
            String valuesAsString = values.stream().map(it -> it.toString() + "(" + it.getClass() + ")").collect(Collectors.joining(", "));
            String signatures = list.stream().map(it -> it.signature().asHumanReadable()).collect(Collectors.joining("\n", "\n", "n"));
            exception = EvaluableException.of("no matching signature found for %s in %s", valuesAsString, signatures);
        }
        return Either.right((Object)exception);
    }

    public static Either<TypedEvaluable<?>, EvaluableException> findType(List<TypedEvaluable<?>> list, List<? extends TypeInfo<?>> valueTypes) {
        EvaluableException exception;
        ArrayList<EvaluableException> errors = new ArrayList<EvaluableException>();
        for (TypedEvaluable<?> evaluable : list) {
            Optional<EvaluableException> error = evaluable.signature().validateArgumentTypes(valueTypes);
            if (error.isPresent()) {
                errors.add(error.get());
                continue;
            }
            return Either.left(evaluable);
        }
        if (errors.size() == 1 && ((EvaluableException)errors.get(0)).isValidationError()) {
            exception = (EvaluableException)errors.get(0);
        } else {
            String valuesAsString = valueTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
            String signatures = list.stream().map(it -> it.signature().asHumanReadable()).collect(Collectors.joining("\n", "\n", "n"));
            exception = EvaluableException.of("no matching signature found for %s in %s", valuesAsString, signatures);
        }
        return Either.right((Object)exception);
    }

    public static EvaluableException signatureNotFound(List<TypedEvaluable<?>> list, List<?> values, List<EvaluableException> errors) {
        if (errors.size() == 1 && errors.get(0).isValidationError()) {
            return errors.get(0);
        }
        String valuesAsString = values.stream().map(it -> it.toString() + "(" + it.getClass() + ")").collect(Collectors.joining(", "));
        String signatures = list.stream().map(it -> it.signature().asHumanReadable()).collect(Collectors.joining("\n", "\n", "n"));
        return EvaluableException.of("no matching signature found for %s in %s", valuesAsString, signatures);
    }
}

