/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.parser;

import de.flapdoodle.eval.core.evaluables.OperatorMap;
import de.flapdoodle.eval.core.evaluables.OperatorMapping;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByArguments;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByName;
import de.flapdoodle.eval.core.exceptions.ParseException;
import de.flapdoodle.eval.core.parser.ASTNode;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.parser.TokenType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;

public class ShuntingYardConverter {
    private final String originalExpression;
    private final List<Token> expressionTokens;
    private final OperatorMap operatorMap;
    private final TypedEvaluableByName evaluatables;
    private final Deque<Token> operatorStack = new ArrayDeque<Token>();
    private final Deque<ASTNode> operandStack = new ArrayDeque<ASTNode>();

    public ShuntingYardConverter(String originalExpression, List<Token> expressionTokens, OperatorMap operatorMap, TypedEvaluableByName evaluatables) {
        this.originalExpression = originalExpression;
        this.expressionTokens = expressionTokens;
        this.operatorMap = operatorMap;
        this.evaluatables = evaluatables;
    }

    public ASTNode toAbstractSyntaxTree() throws ParseException {
        Token previousToken = null;
        for (Token currentToken : this.expressionTokens) {
            switch (currentToken.type()) {
                case VARIABLE_OR_CONSTANT: 
                case NUMBER_LITERAL: 
                case STRING_LITERAL: {
                    this.operandStack.push(ASTNode.of(currentToken, new ASTNode[0]));
                    break;
                }
                case FUNCTION: {
                    this.operatorStack.push(currentToken);
                    break;
                }
                case COMMA: {
                    this.processOperatorsFromStackUntilTokenType(TokenType.BRACE_OPEN);
                    break;
                }
                case INFIX_OPERATOR: 
                case PREFIX_OPERATOR: 
                case POSTFIX_OPERATOR: {
                    this.processOperator(currentToken);
                    break;
                }
                case BRACE_OPEN: {
                    this.processBraceOpen(previousToken, currentToken);
                    break;
                }
                case BRACE_CLOSE: {
                    this.processBraceClose();
                    break;
                }
                case ARRAY_OPEN: {
                    this.processArrayOpen(currentToken);
                    break;
                }
                case ARRAY_CLOSE: {
                    this.processArrayClose();
                    break;
                }
                case ASSOCIATE_OPEN: {
                    this.processAssociateOpen(currentToken);
                    break;
                }
                case ASSOCIATE_CLOSE: {
                    this.processAssociateClose();
                    break;
                }
                case STRUCTURE_SEPARATOR: {
                    this.processStructureSeparator(currentToken);
                    break;
                }
                default: {
                    throw new ParseException(currentToken, "Unexpected token of type '" + (Object)((Object)currentToken.type()) + "'");
                }
            }
            previousToken = currentToken;
        }
        while (!this.operatorStack.isEmpty()) {
            Token token = this.operatorStack.pop();
            this.createOperatorNode(token);
        }
        if (this.operandStack.isEmpty()) {
            throw new ParseException(this.originalExpression, "Empty expression");
        }
        if (this.operandStack.size() > 1) {
            throw new ParseException(this.originalExpression, "Too many operands");
        }
        return this.operandStack.pop();
    }

    private void processStructureSeparator(Token currentToken) throws ParseException {
        Token nextToken;
        Token token = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (nextToken != null && nextToken.type() == TokenType.STRUCTURE_SEPARATOR) {
            Token token2 = this.operatorStack.pop();
            this.createOperatorNode(token2);
            nextToken = this.operatorStack.peek();
        }
        this.operatorStack.push(currentToken);
    }

    private void processBraceOpen(Token previousToken, Token currentToken) {
        if (previousToken != null && previousToken.type() == TokenType.FUNCTION) {
            Token paramStart = Token.of(currentToken.start(), currentToken.value(), TokenType.FUNCTION_PARAM_START);
            this.operandStack.push(ASTNode.of(paramStart, new ASTNode[0]));
        }
        this.operatorStack.push(currentToken);
    }

    private void processBraceClose() throws ParseException {
        this.processOperatorsFromStackUntilTokenType(TokenType.BRACE_OPEN);
        this.operatorStack.pop();
        if (!this.operatorStack.isEmpty() && this.operatorStack.peek().type() == TokenType.FUNCTION) {
            ASTNode node;
            Token functionToken = this.operatorStack.pop();
            ArrayList<ASTNode> parameters = new ArrayList<ASTNode>();
            while ((node = this.operandStack.pop()).getToken().type() != TokenType.FUNCTION_PARAM_START) {
                parameters.add(0, node);
            }
            this.validateFunctionParameters(functionToken, parameters);
            this.operandStack.push(ASTNode.of(functionToken, parameters.toArray(new ASTNode[0])));
        }
    }

    private void validateFunctionParameters(Token functionToken, ArrayList<ASTNode> parameters) throws ParseException {
        Optional<? extends TypedEvaluableByArguments> evaluatable = this.evaluatables.find(functionToken.value(), parameters.size());
        if (!evaluatable.isPresent()) {
            throw new ParseException(functionToken, "could not find evaluatable '" + functionToken.value() + "' with " + parameters.size() + " arguments");
        }
    }

    private void processArrayOpen(Token currentToken) throws ParseException {
        Token nextToken;
        Token token = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (nextToken != null && nextToken.type() == TokenType.STRUCTURE_SEPARATOR) {
            Token token2 = this.operatorStack.pop();
            this.createOperatorNode(token2);
            nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        }
        Token arrayIndex = Token.of(currentToken.start(), currentToken.value(), TokenType.ARRAY_INDEX);
        this.operatorStack.push(arrayIndex);
        this.operatorStack.push(currentToken);
    }

    private void processAssociateOpen(Token currentToken) throws ParseException {
        Token nextToken;
        Token token = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (nextToken != null && nextToken.type() == TokenType.STRUCTURE_SEPARATOR) {
            Token token2 = this.operatorStack.pop();
            this.createOperatorNode(token2);
            nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        }
        Token associateIndex = Token.of(currentToken.start(), currentToken.value(), TokenType.ASSOCIATE_INDEX);
        this.operatorStack.push(associateIndex);
        this.operatorStack.push(currentToken);
    }

    private void processArrayClose() throws ParseException {
        this.processOperatorsFromStackUntilTokenType(TokenType.ARRAY_OPEN);
        this.operatorStack.pop();
        Token arrayToken = this.operatorStack.pop();
        ArrayList<ASTNode> operands = new ArrayList<ASTNode>();
        ASTNode index = this.operandStack.pop();
        operands.add(0, index);
        ASTNode array = this.operandStack.pop();
        operands.add(0, array);
        this.operandStack.push(ASTNode.of(arrayToken, operands.toArray(new ASTNode[0])));
    }

    private void processAssociateClose() throws ParseException {
        this.processOperatorsFromStackUntilTokenType(TokenType.ASSOCIATE_OPEN);
        this.operatorStack.pop();
        Token arrayToken = this.operatorStack.pop();
        ArrayList<ASTNode> operands = new ArrayList<ASTNode>();
        ASTNode index = this.operandStack.pop();
        operands.add(0, index);
        ASTNode array = this.operandStack.pop();
        operands.add(0, array);
        this.operandStack.push(ASTNode.of(arrayToken, operands.toArray(new ASTNode[0])));
    }

    private void processOperatorsFromStackUntilTokenType(TokenType untilTokenType) throws ParseException {
        while (!this.operatorStack.isEmpty() && this.operatorStack.peek().type() != untilTokenType) {
            Token token = this.operatorStack.pop();
            this.createOperatorNode(token);
        }
    }

    private void createOperatorNode(Token token) throws ParseException {
        if (this.operandStack.isEmpty()) {
            throw new ParseException(token, "Missing operand for operator");
        }
        ASTNode operand1 = this.operandStack.pop();
        if (token.type() == TokenType.PREFIX_OPERATOR || token.type() == TokenType.POSTFIX_OPERATOR) {
            this.operandStack.push(ASTNode.of(token, operand1));
        } else {
            if (this.operandStack.isEmpty()) {
                throw new ParseException(token, "Missing second operand for operator");
            }
            ASTNode operand2 = this.operandStack.pop();
            this.operandStack.push(ASTNode.of(token, operand2, operand1));
        }
    }

    private void processOperator(Token currentToken) throws ParseException {
        Token nextToken;
        Token token = nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        while (this.isOperator(nextToken) && this.isNextOperatorOfHigherPrecedence(currentToken, nextToken)) {
            Token token2 = this.operatorStack.pop();
            this.createOperatorNode(token2);
            nextToken = this.operatorStack.isEmpty() ? null : this.operatorStack.peek();
        }
        this.operatorStack.push(currentToken);
    }

    private boolean isNextOperatorOfHigherPrecedence(Token currentOperator, Token nextOperator) throws ParseException {
        return this.isNextOperatorOfHigherPrecedence(this.operatorMapping(currentOperator), this.operatorMapping(nextOperator));
    }

    private OperatorMapping operatorMapping(Token token) throws ParseException {
        switch (token.type()) {
            case PREFIX_OPERATOR: {
                return this.operatorMap.prefixOperator(token.value()).orElse(null);
            }
            case POSTFIX_OPERATOR: {
                return this.operatorMap.postfixOperator(token.value()).orElse(null);
            }
            case INFIX_OPERATOR: {
                return this.operatorMap.infixOperator(token.value()).orElse(null);
            }
        }
        return null;
    }

    private boolean isNextOperatorOfHigherPrecedence(OperatorMapping currentOperator, OperatorMapping nextOperator) {
        if (nextOperator == null) {
            return true;
        }
        if (currentOperator.isLeftAssociative()) {
            return currentOperator.precedence() <= nextOperator.precedence();
        }
        return currentOperator.precedence() < nextOperator.precedence();
    }

    private boolean isOperator(Token token) {
        if (token == null) {
            return false;
        }
        TokenType tokenType = token.type();
        switch (tokenType) {
            case INFIX_OPERATOR: 
            case PREFIX_OPERATOR: 
            case POSTFIX_OPERATOR: 
            case STRUCTURE_SEPARATOR: {
                return true;
            }
        }
        return false;
    }
}

