/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.parser;

import de.flapdoodle.eval.core.evaluables.HasOperator;
import de.flapdoodle.eval.core.evaluables.OperatorType;
import de.flapdoodle.eval.core.exceptions.ParseException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.parser.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Tokenizer {
    private final String expressionString;
    private final HasOperator operators;
    private final char[] chars;
    private final int end;
    private final List<Token> tokens = new ArrayList<Token>();
    private int index = 0;
    private int braceBalance = 0;
    private int arrayBalance = 0;
    private int associateBalance = 0;

    public Tokenizer(String expressionString, HasOperator operators) {
        this.expressionString = expressionString;
        this.operators = operators;
        this.chars = expressionString.toCharArray();
        this.end = this.chars.length;
    }

    public List<Token> parse() throws ParseException {
        Optional<Token> token;
        while ((token = this.nextToken()).isPresent()) {
            Token currentToken = token.get();
            if (this.implicitMultiplicationPossible(currentToken)) {
                Token multiplication = Token.of(currentToken.start(), "*", TokenType.INFIX_OPERATOR);
                this.tokens.add(multiplication);
            }
            this.validateToken(currentToken);
            this.tokens.add(currentToken);
        }
        if (this.braceBalance > 0) {
            throw new ParseException(this.expressionString, "Closing brace not found");
        }
        if (this.arrayBalance > 0) {
            throw new ParseException(this.expressionString, "Closing array not found");
        }
        if (this.associateBalance > 0) {
            throw new ParseException(this.expressionString, "Closing associate not found");
        }
        return this.tokens;
    }

    private boolean implicitMultiplicationPossible(Token currentToken) {
        switch (currentToken.type()) {
            case BRACE_OPEN: {
                return this.isPreviousTokenType(TokenType.BRACE_CLOSE, TokenType.NUMBER_LITERAL);
            }
            case VARIABLE_OR_CONSTANT: {
                return this.isPreviousTokenType(TokenType.NUMBER_LITERAL);
            }
        }
        return false;
    }

    private void validateToken(Token currentToken) throws ParseException {
        if (this.isPreviousTokenType(TokenType.INFIX_OPERATOR) && this.invalidTokenAfterInfixOperator(currentToken)) {
            throw new ParseException(currentToken, "Unexpected token after infix operator");
        }
    }

    private boolean invalidTokenAfterInfixOperator(Token token) {
        switch (token.type()) {
            case INFIX_OPERATOR: 
            case BRACE_CLOSE: 
            case COMMA: {
                return true;
            }
        }
        return false;
    }

    private Optional<Token> nextToken() throws ParseException {
        this.skipBlanks();
        return this.eof() ? Optional.empty() : Optional.of(this.parseNextToken());
    }

    private Token parseNextToken() throws ParseException {
        char currentChar = this.get();
        if (currentChar == '\"') {
            return this.parseStringLiteral();
        }
        if (currentChar == '(') {
            return this.parseBraceOpen();
        }
        if (currentChar == ')') {
            return this.parseBraceClose();
        }
        if (currentChar == '[') {
            return this.parseArrayOpen();
        }
        if (currentChar == ']') {
            return this.parseArrayClose();
        }
        if (currentChar == '{') {
            return this.parseAssociateOpen();
        }
        if (currentChar == '}') {
            return this.parseAssociateClose();
        }
        if (currentChar == '.' && !this.isNextCharNumberChar()) {
            return this.parseStructureSeparator();
        }
        if (currentChar == ',') {
            Token token = Token.of(this.index, ",", TokenType.COMMA);
            this.next();
            return token;
        }
        if (Tokenizer.isIdentifierStart(currentChar)) {
            return this.parseIdentifier();
        }
        if (this.isNumberStart(0)) {
            return this.parseNumberLiteral();
        }
        if (currentChar == '.') {
            Token token = Token.of(this.index, ".", TokenType.STRUCTURE_SEPARATOR);
            this.next();
            return token;
        }
        return this.parseOperator();
    }

    private Token parseStructureSeparator() throws ParseException {
        Token token = Token.of(this.index, ".", TokenType.STRUCTURE_SEPARATOR);
        if (this.arrayOrAssociateOpenOrStructureSeparatorNotAllowed()) {
            throw new ParseException(token, "Structure separator not allowed here");
        }
        this.next();
        return token;
    }

    private Token parseArrayClose() throws ParseException {
        Token token = Token.of(this.index, "]", TokenType.ARRAY_CLOSE);
        if (!this.arrayOrAssociateCloseAllowed()) {
            throw new ParseException(token, "Array close not allowed here");
        }
        this.next();
        if (this.arrayBalance <= 0) {
            throw new ParseException(token, "Unexpected closing array");
        }
        --this.arrayBalance;
        return token;
    }

    private Token parseArrayOpen() throws ParseException {
        Token token = Token.of(this.index, "[", TokenType.ARRAY_OPEN);
        if (this.arrayOrAssociateOpenOrStructureSeparatorNotAllowed()) {
            throw new ParseException(token, "Array open not allowed here");
        }
        this.next();
        ++this.arrayBalance;
        return token;
    }

    private Token parseAssociateClose() throws ParseException {
        Token token = Token.of(this.index, "}", TokenType.ASSOCIATE_CLOSE);
        if (!this.arrayOrAssociateCloseAllowed()) {
            throw new ParseException(token, "Associate close not allowed here");
        }
        this.next();
        if (this.associateBalance <= 0) {
            throw new ParseException(token, "Unexpected closing associate");
        }
        --this.associateBalance;
        return token;
    }

    private Token parseAssociateOpen() throws ParseException {
        Token token = Token.of(this.index, "{", TokenType.ASSOCIATE_OPEN);
        if (this.arrayOrAssociateOpenOrStructureSeparatorNotAllowed()) {
            throw new ParseException(token, "Associate open not allowed here");
        }
        this.next();
        ++this.associateBalance;
        return token;
    }

    private Token parseBraceClose() throws ParseException {
        Token token = Token.of(this.index, ")", TokenType.BRACE_CLOSE);
        this.next();
        if (this.braceBalance <= 0) {
            throw new ParseException(token, "Unexpected closing brace");
        }
        --this.braceBalance;
        return token;
    }

    private Token parseBraceOpen() {
        Token token = Token.of(this.index, "(", TokenType.BRACE_OPEN);
        this.next();
        ++this.braceBalance;
        return token;
    }

    private boolean isPreviousTokenType(TokenType ... match) {
        return this.matchPreviousTokenType(match).orElse(false);
    }

    private Optional<Boolean> dontMatchPreviousTokenType(TokenType ... match) {
        return this.matchPreviousTokenType(match).map(it -> it == false);
    }

    private Optional<Boolean> matchPreviousTokenType(TokenType ... match) {
        return (this.tokens.isEmpty() ? Optional.empty() : Optional.of(this.tokens.get(this.tokens.size() - 1).type())).map(type -> {
            for (TokenType m : match) {
                if (m != type) continue;
                return true;
            }
            return false;
        });
    }

    private Token parseOperator() throws ParseException {
        String tokenString;
        char currentChar;
        int tokenStartIndex = this.index;
        boolean prefixOperatorAllowed = this.prefixOperatorAllowed();
        boolean postfixOperatorAllowed = this.postfixOperatorAllowed();
        boolean infixOperatorAllowed = this.infixOperatorAllowed();
        StringBuilder tokenValue = new StringBuilder();
        while ((currentChar = this.get()) != '\u0000') {
            tokenValue.append(currentChar);
            tokenString = tokenValue.toString();
            String possibleNextOperator = tokenString + this.peek(1);
            boolean possibleNextOperatorFound = prefixOperatorAllowed && this.operators.hasStartingWith(OperatorType.Prefix, possibleNextOperator) || postfixOperatorAllowed && this.operators.hasStartingWith(OperatorType.Postfix, possibleNextOperator) || infixOperatorAllowed && this.operators.hasStartingWith(OperatorType.Infix, possibleNextOperator);
            this.next();
            if (possibleNextOperatorFound) continue;
            break;
        }
        tokenString = tokenValue.toString();
        if (prefixOperatorAllowed && this.operators.matching(OperatorType.Prefix, tokenString)) {
            return Token.of(tokenStartIndex, tokenString, TokenType.PREFIX_OPERATOR);
        }
        if (postfixOperatorAllowed && this.operators.matching(OperatorType.Postfix, tokenString)) {
            return Token.of(tokenStartIndex, tokenString, TokenType.POSTFIX_OPERATOR);
        }
        if (this.operators.matching(OperatorType.Infix, tokenString)) {
            return Token.of(tokenStartIndex, tokenString, TokenType.INFIX_OPERATOR);
        }
        throw new ParseException(tokenStartIndex, tokenStartIndex + tokenString.length() - 1, tokenString, "Undefined operator '" + tokenString + "'");
    }

    private boolean arrayOrAssociateOpenOrStructureSeparatorNotAllowed() {
        return !this.isPreviousTokenType(TokenType.BRACE_CLOSE, TokenType.VARIABLE_OR_CONSTANT, TokenType.ARRAY_CLOSE, TokenType.ASSOCIATE_CLOSE, TokenType.STRING_LITERAL);
    }

    private boolean arrayOrAssociateCloseAllowed() {
        return this.dontMatchPreviousTokenType(TokenType.BRACE_OPEN, TokenType.INFIX_OPERATOR, TokenType.PREFIX_OPERATOR, TokenType.FUNCTION, TokenType.COMMA, TokenType.ARRAY_OPEN, TokenType.ASSOCIATE_OPEN).orElse(false);
    }

    private boolean prefixOperatorAllowed() {
        return this.matchPreviousTokenType(TokenType.BRACE_OPEN, TokenType.INFIX_OPERATOR, TokenType.COMMA, TokenType.PREFIX_OPERATOR).orElse(true);
    }

    private boolean postfixOperatorAllowed() {
        return this.isPreviousTokenType(TokenType.BRACE_CLOSE, TokenType.NUMBER_LITERAL, TokenType.VARIABLE_OR_CONSTANT, TokenType.STRING_LITERAL);
    }

    private boolean infixOperatorAllowed() {
        return this.isPreviousTokenType(TokenType.BRACE_CLOSE, TokenType.VARIABLE_OR_CONSTANT, TokenType.STRING_LITERAL, TokenType.POSTFIX_OPERATOR, TokenType.NUMBER_LITERAL);
    }

    private Token parseNumberLiteral() throws ParseException {
        char currentChar = this.get();
        char nextChar = this.peek(1);
        if (currentChar == '0' && (nextChar == 'x' || nextChar == 'X')) {
            return this.parseHexNumberLiteral();
        }
        return this.parseDecimalNumberLiteral();
    }

    private Token parseDecimalNumberLiteral() throws ParseException {
        int tokenStartIndex = this.index;
        StringBuilder tokenValue = new StringBuilder();
        int lastChar = 0;
        boolean scientificNotation = false;
        while (this.notEof() && this.isNumberChar(0)) {
            char currentChar = this.get();
            if (currentChar == 'e' || currentChar == 'E') {
                scientificNotation = true;
            }
            tokenValue.append(currentChar);
            lastChar = currentChar;
            this.next();
        }
        if (scientificNotation && (lastChar == 101 || lastChar == 69 || lastChar == 43 || lastChar == 45 || lastChar == 46)) {
            throw new ParseException(Token.of(tokenStartIndex, tokenValue.toString(), TokenType.NUMBER_LITERAL), "Illegal scientific format");
        }
        return Token.of(tokenStartIndex, tokenValue.toString(), TokenType.NUMBER_LITERAL);
    }

    private Token parseHexNumberLiteral() {
        char currentChar;
        int tokenStartIndex = this.index;
        StringBuilder tokenValue = new StringBuilder();
        tokenValue.append(this.get());
        this.next();
        tokenValue.append(this.get());
        this.next();
        while ((currentChar = this.get()) != '\u0000' && Tokenizer.isHexChar(currentChar)) {
            tokenValue.append(currentChar);
            this.next();
        }
        return Token.of(tokenStartIndex, tokenValue.toString(), TokenType.NUMBER_LITERAL);
    }

    private Token parseIdentifier() throws ParseException {
        char currentChar;
        int tokenStartIndex = this.index;
        StringBuilder tokenValue = new StringBuilder();
        boolean firstChar = true;
        while ((currentChar = this.get()) != '\u0000' && (Tokenizer.isIdentifierChar(currentChar) || firstChar && Tokenizer.isIdentifierStart(currentChar))) {
            firstChar = false;
            tokenValue.append(currentChar);
            this.next();
        }
        String tokenName = tokenValue.toString();
        if (this.prefixOperatorAllowed() && this.operators.matching(OperatorType.Prefix, tokenName)) {
            return Token.of(tokenStartIndex, tokenName, TokenType.PREFIX_OPERATOR);
        }
        if (this.postfixOperatorAllowed() && this.operators.matching(OperatorType.Postfix, tokenName)) {
            return Token.of(tokenStartIndex, tokenName, TokenType.POSTFIX_OPERATOR);
        }
        if (this.operators.matching(OperatorType.Infix, tokenName)) {
            return Token.of(tokenStartIndex, tokenName, TokenType.INFIX_OPERATOR);
        }
        this.skipBlanks();
        currentChar = this.get();
        if (currentChar == '(') {
            return Token.of(tokenStartIndex, tokenName, TokenType.FUNCTION);
        }
        return Token.of(tokenStartIndex, tokenName, TokenType.VARIABLE_OR_CONSTANT);
    }

    Token parseStringLiteral() throws ParseException {
        int tokenStartIndex = this.index;
        StringBuilder tokenValue = new StringBuilder();
        this.next();
        boolean inQuote = true;
        while (inQuote && this.notEof()) {
            char currentChar = this.get();
            if (currentChar == '\\') {
                this.next();
                tokenValue.append(this.escapeCharacter(this.get()));
            } else if (currentChar == '\"') {
                inQuote = false;
            } else {
                tokenValue.append(currentChar);
            }
            this.next();
        }
        if (inQuote) {
            throw new ParseException(tokenStartIndex, this.index, tokenValue.toString(), "Closing quote not found");
        }
        return Token.of(tokenStartIndex, tokenValue.toString(), TokenType.STRING_LITERAL);
    }

    private char escapeCharacter(int character) throws ParseException {
        switch (character) {
            case 39: {
                return '\'';
            }
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
        }
        throw new ParseException(this.index, 1, "\\" + (char)character, "Unknown escape character");
    }

    private boolean isNumberStart(int offset) {
        char currentChar = this.peek(offset);
        if (Character.isDigit(currentChar)) {
            return true;
        }
        return currentChar == '.' && Character.isDigit(this.peek(offset + 1));
    }

    private boolean isNumberChar(int offset) {
        char currentChar = this.peek(offset);
        char previousChar = this.peek(offset - 1);
        if ((previousChar == 'e' || previousChar == 'E') && currentChar != '.') {
            return Character.isDigit(currentChar) || currentChar == '+' || currentChar == '-';
        }
        if (previousChar == '.') {
            return Character.isDigit(currentChar) || currentChar == 'e' || currentChar == 'E';
        }
        return Character.isDigit(currentChar) || currentChar == '.' || currentChar == 'e' || currentChar == 'E';
    }

    private boolean isNextCharNumberChar() {
        return this.hasNext() && this.isNumberChar(1);
    }

    private static boolean isHexChar(char current) {
        switch (current) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    private static boolean isIdentifierStart(char currentChar) {
        return Character.isLetter(currentChar) || currentChar == '_' || currentChar == '#';
    }

    private static boolean isIdentifierChar(char currentChar) {
        return Character.isLetter(currentChar) || Character.isDigit(currentChar) || currentChar == '_';
    }

    private void skipBlanks() {
        while (this.notEof() && Character.isWhitespace(this.get())) {
            ++this.index;
        }
    }

    private void next() {
        if (this.notEof()) {
            ++this.index;
        }
    }

    private boolean hasNext() {
        return this.has(1);
    }

    private boolean has(int offset) {
        if (this.index + offset < 0) {
            return false;
        }
        return this.index + offset < this.end;
    }

    private char peek(int offset) {
        return this.has(offset) ? this.chars[this.index + offset] : (char)'\u0000';
    }

    private boolean eof() {
        return this.index >= this.end;
    }

    private boolean notEof() {
        return !this.eof();
    }

    private char get() {
        return this.peek(0);
    }
}

