/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core.tree;

import de.flapdoodle.eval.core.evaluables.Evaluated;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.tree.Node;
import de.flapdoodle.eval.core.tree.ValueNode;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ValueNode", generator="Immutables")
public final class ImmutableValueNode<T>
extends ValueNode<T> {
    private final Token token;
    private final Evaluated<T> value;

    private ImmutableValueNode(Token token, Evaluated<T> value) {
        this.token = Objects.requireNonNull(token, "token");
        this.value = Objects.requireNonNull(value, "value");
    }

    private ImmutableValueNode(ImmutableValueNode<T> original, Token token, Evaluated<T> value) {
        this.token = token;
        this.value = value;
    }

    @Override
    public Token token() {
        return this.token;
    }

    @Override
    protected Evaluated<T> value() {
        return this.value;
    }

    public final ImmutableValueNode<T> withToken(Token value) {
        if (this.token == value) {
            return this;
        }
        Token newValue = Objects.requireNonNull(value, "token");
        return new ImmutableValueNode<T>(this, newValue, this.value);
    }

    public final ImmutableValueNode<T> withValue(Evaluated<T> value) {
        if (this.value == value) {
            return this;
        }
        Evaluated<T> newValue = Objects.requireNonNull(value, "value");
        return new ImmutableValueNode<T>(this, this.token, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueNode && this.equalTo(0, (ImmutableValueNode)another);
    }

    private boolean equalTo(int synthetic, ImmutableValueNode<?> another) {
        return this.token.equals(another.token) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ValueNode{token=" + this.token + ", value=" + this.value + "}";
    }

    public static <T> ImmutableValueNode<T> of(Token token, Evaluated<T> value) {
        return new ImmutableValueNode<T>(token, value);
    }

    public static <T> ImmutableValueNode<T> copyOf(ValueNode<T> instance) {
        if (instance instanceof ImmutableValueNode) {
            return (ImmutableValueNode)instance;
        }
        return ImmutableValueNode.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="ValueNode", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private Token token;
        private Evaluated<T> value;

        private Builder() {
        }

        public final Builder<T> from(ValueNode<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder<T> from(Node instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Node instance;
            if (object instanceof ValueNode) {
                instance = (ValueNode)object;
                this.value(((ValueNode)instance).value());
            }
            if (object instanceof Node) {
                instance = (Node)object;
                this.token(instance.token());
            }
        }

        public final Builder<T> token(Token token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> value(Evaluated<T> value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableValueNode<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueNode(null, this.token, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build ValueNode, some of required attributes are not set " + attributes;
        }
    }
}

