/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.arithmetic;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.example.Value;
import java.math.BigDecimal;

public class Factorial
extends TypedEvaluables.Wrapper {
    public Factorial() {
        super(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Value.NumberValue.class, new Number())).build());
    }

    public static class Number
    implements TypedEvaluable.Arg1<Value.NumberValue, Value.NumberValue> {
        @Override
        public Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue argument) throws EvaluationException {
            int number = ((BigDecimal)argument.wrapped()).intValue();
            BigDecimal factorial = BigDecimal.ONE;
            for (int i = 1; i <= number; ++i) {
                factorial = factorial.multiply(new BigDecimal(i, evaluationContext.mathContext()), evaluationContext.mathContext());
            }
            return Value.of(factorial);
        }
    }
}

