package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.evaluables.OperatorMap;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByName;
import de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments;
import de.flapdoodle.eval.core.tree.EvaluableExceptionMapper;
import java.math.MathContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExpressionFactory}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExpressionFactory.builder()}.
 */
@Generated(from = "ExpressionFactory", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableExpressionFactory extends ExpressionFactory {
  private final MathContext mathContext;
  private final ZoneId zoneId;
  private final VariableResolver constants;
  private final TypedEvaluableByName evaluatables;
  private final TypedEvaluableByNumberOfArguments arrayAccess;
  private final TypedEvaluableByNumberOfArguments associateAccess;
  private final TypedEvaluableByNumberOfArguments propertyAccess;
  private final NumberAsValue numberAsValue;
  private final StringAsValue stringAsValue;
  private final EvaluableExceptionMapper exceptionMapper;
  private final OperatorMap operatorMap;

  private ImmutableExpressionFactory(ImmutableExpressionFactory.Builder builder) {
    this.constants = builder.constants;
    this.evaluatables = builder.evaluatables;
    this.arrayAccess = builder.arrayAccess;
    this.associateAccess = builder.associateAccess;
    this.propertyAccess = builder.propertyAccess;
    this.numberAsValue = builder.numberAsValue;
    this.stringAsValue = builder.stringAsValue;
    this.exceptionMapper = builder.exceptionMapper;
    this.operatorMap = builder.operatorMap;
    if (builder.mathContext != null) {
      initShim.mathContext(builder.mathContext);
    }
    if (builder.zoneId != null) {
      initShim.zoneId(builder.zoneId);
    }
    this.mathContext = initShim.mathContext();
    this.zoneId = initShim.zoneId();
    this.initShim = null;
  }

  private ImmutableExpressionFactory(
      MathContext mathContext,
      ZoneId zoneId,
      VariableResolver constants,
      TypedEvaluableByName evaluatables,
      TypedEvaluableByNumberOfArguments arrayAccess,
      TypedEvaluableByNumberOfArguments associateAccess,
      TypedEvaluableByNumberOfArguments propertyAccess,
      NumberAsValue numberAsValue,
      StringAsValue stringAsValue,
      EvaluableExceptionMapper exceptionMapper,
      OperatorMap operatorMap) {
    this.mathContext = mathContext;
    this.zoneId = zoneId;
    this.constants = constants;
    this.evaluatables = evaluatables;
    this.arrayAccess = arrayAccess;
    this.associateAccess = associateAccess;
    this.propertyAccess = propertyAccess;
    this.numberAsValue = numberAsValue;
    this.stringAsValue = stringAsValue;
    this.exceptionMapper = exceptionMapper;
    this.operatorMap = operatorMap;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ExpressionFactory", generator = "Immutables")
  private final class InitShim {
    private byte mathContextBuildStage = STAGE_UNINITIALIZED;
    private MathContext mathContext;

    MathContext mathContext() {
      if (mathContextBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (mathContextBuildStage == STAGE_UNINITIALIZED) {
        mathContextBuildStage = STAGE_INITIALIZING;
        this.mathContext = Objects.requireNonNull(ImmutableExpressionFactory.super.mathContext(), "mathContext");
        mathContextBuildStage = STAGE_INITIALIZED;
      }
      return this.mathContext;
    }

    void mathContext(MathContext mathContext) {
      this.mathContext = mathContext;
      mathContextBuildStage = STAGE_INITIALIZED;
    }

    private byte zoneIdBuildStage = STAGE_UNINITIALIZED;
    private ZoneId zoneId;

    ZoneId zoneId() {
      if (zoneIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (zoneIdBuildStage == STAGE_UNINITIALIZED) {
        zoneIdBuildStage = STAGE_INITIALIZING;
        this.zoneId = Objects.requireNonNull(ImmutableExpressionFactory.super.zoneId(), "zoneId");
        zoneIdBuildStage = STAGE_INITIALIZED;
      }
      return this.zoneId;
    }

    void zoneId(ZoneId zoneId) {
      this.zoneId = zoneId;
      zoneIdBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (mathContextBuildStage == STAGE_INITIALIZING) attributes.add("mathContext");
      if (zoneIdBuildStage == STAGE_INITIALIZING) attributes.add("zoneId");
      return "Cannot build ExpressionFactory, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code mathContext} attribute
   */
  @Override
  public MathContext mathContext() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.mathContext()
        : this.mathContext;
  }

  /**
   * @return The value of the {@code zoneId} attribute
   */
  @Override
  protected ZoneId zoneId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.zoneId()
        : this.zoneId;
  }

  /**
   * @return The value of the {@code constants} attribute
   */
  @Override
  public VariableResolver constants() {
    return constants;
  }

  /**
   * @return The value of the {@code evaluatables} attribute
   */
  @Override
  public TypedEvaluableByName evaluatables() {
    return evaluatables;
  }

  /**
   * @return The value of the {@code arrayAccess} attribute
   */
  @Override
  protected TypedEvaluableByNumberOfArguments arrayAccess() {
    return arrayAccess;
  }

  /**
   * @return The value of the {@code associateAccess} attribute
   */
  @Override
  protected TypedEvaluableByNumberOfArguments associateAccess() {
    return associateAccess;
  }

  /**
   * @return The value of the {@code propertyAccess} attribute
   */
  @Override
  protected TypedEvaluableByNumberOfArguments propertyAccess() {
    return propertyAccess;
  }

  /**
   * @return The value of the {@code numberAsValue} attribute
   */
  @Override
  protected NumberAsValue numberAsValue() {
    return numberAsValue;
  }

  /**
   * @return The value of the {@code stringAsValue} attribute
   */
  @Override
  protected StringAsValue stringAsValue() {
    return stringAsValue;
  }

  /**
   * @return The value of the {@code exceptionMapper} attribute
   */
  @Override
  protected EvaluableExceptionMapper exceptionMapper() {
    return exceptionMapper;
  }

  /**
   * @return The value of the {@code operatorMap} attribute
   */
  @Override
  public OperatorMap operatorMap() {
    return operatorMap;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#mathContext() mathContext} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mathContext
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withMathContext(MathContext value) {
    if (this.mathContext == value) return this;
    MathContext newValue = Objects.requireNonNull(value, "mathContext");
    return new ImmutableExpressionFactory(
        newValue,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#zoneId() zoneId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zoneId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withZoneId(ZoneId value) {
    if (this.zoneId == value) return this;
    ZoneId newValue = Objects.requireNonNull(value, "zoneId");
    return new ImmutableExpressionFactory(
        this.mathContext,
        newValue,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#constants() constants} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constants
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withConstants(VariableResolver value) {
    if (this.constants == value) return this;
    VariableResolver newValue = Objects.requireNonNull(value, "constants");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        newValue,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#evaluatables() evaluatables} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for evaluatables
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withEvaluatables(TypedEvaluableByName value) {
    if (this.evaluatables == value) return this;
    TypedEvaluableByName newValue = Objects.requireNonNull(value, "evaluatables");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        newValue,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#arrayAccess() arrayAccess} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for arrayAccess
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withArrayAccess(TypedEvaluableByNumberOfArguments value) {
    if (this.arrayAccess == value) return this;
    TypedEvaluableByNumberOfArguments newValue = Objects.requireNonNull(value, "arrayAccess");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        newValue,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#associateAccess() associateAccess} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for associateAccess
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withAssociateAccess(TypedEvaluableByNumberOfArguments value) {
    if (this.associateAccess == value) return this;
    TypedEvaluableByNumberOfArguments newValue = Objects.requireNonNull(value, "associateAccess");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        newValue,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#propertyAccess() propertyAccess} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertyAccess
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withPropertyAccess(TypedEvaluableByNumberOfArguments value) {
    if (this.propertyAccess == value) return this;
    TypedEvaluableByNumberOfArguments newValue = Objects.requireNonNull(value, "propertyAccess");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        newValue,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#numberAsValue() numberAsValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for numberAsValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withNumberAsValue(NumberAsValue value) {
    if (this.numberAsValue == value) return this;
    NumberAsValue newValue = Objects.requireNonNull(value, "numberAsValue");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        newValue,
        this.stringAsValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#stringAsValue() stringAsValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stringAsValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withStringAsValue(StringAsValue value) {
    if (this.stringAsValue == value) return this;
    StringAsValue newValue = Objects.requireNonNull(value, "stringAsValue");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        newValue,
        this.exceptionMapper,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#exceptionMapper() exceptionMapper} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exceptionMapper
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withExceptionMapper(EvaluableExceptionMapper value) {
    if (this.exceptionMapper == value) return this;
    EvaluableExceptionMapper newValue = Objects.requireNonNull(value, "exceptionMapper");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        newValue,
        this.operatorMap);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExpressionFactory#operatorMap() operatorMap} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operatorMap
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpressionFactory withOperatorMap(OperatorMap value) {
    if (this.operatorMap == value) return this;
    OperatorMap newValue = Objects.requireNonNull(value, "operatorMap");
    return new ImmutableExpressionFactory(
        this.mathContext,
        this.zoneId,
        this.constants,
        this.evaluatables,
        this.arrayAccess,
        this.associateAccess,
        this.propertyAccess,
        this.numberAsValue,
        this.stringAsValue,
        this.exceptionMapper,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExpressionFactory} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExpressionFactory
        && equalTo(0, (ImmutableExpressionFactory) another);
  }

  private boolean equalTo(int synthetic, ImmutableExpressionFactory another) {
    return mathContext.equals(another.mathContext)
        && zoneId.equals(another.zoneId)
        && constants.equals(another.constants)
        && evaluatables.equals(another.evaluatables)
        && arrayAccess.equals(another.arrayAccess)
        && associateAccess.equals(another.associateAccess)
        && propertyAccess.equals(another.propertyAccess)
        && numberAsValue.equals(another.numberAsValue)
        && stringAsValue.equals(another.stringAsValue)
        && exceptionMapper.equals(another.exceptionMapper)
        && operatorMap.equals(another.operatorMap);
  }

  /**
   * Computes a hash code from attributes: {@code mathContext}, {@code zoneId}, {@code constants}, {@code evaluatables}, {@code arrayAccess}, {@code associateAccess}, {@code propertyAccess}, {@code numberAsValue}, {@code stringAsValue}, {@code exceptionMapper}, {@code operatorMap}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + mathContext.hashCode();
    h += (h << 5) + zoneId.hashCode();
    h += (h << 5) + constants.hashCode();
    h += (h << 5) + evaluatables.hashCode();
    h += (h << 5) + arrayAccess.hashCode();
    h += (h << 5) + associateAccess.hashCode();
    h += (h << 5) + propertyAccess.hashCode();
    h += (h << 5) + numberAsValue.hashCode();
    h += (h << 5) + stringAsValue.hashCode();
    h += (h << 5) + exceptionMapper.hashCode();
    h += (h << 5) + operatorMap.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExpressionFactory} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExpressionFactory{"
        + "mathContext=" + mathContext
        + ", zoneId=" + zoneId
        + ", constants=" + constants
        + ", evaluatables=" + evaluatables
        + ", arrayAccess=" + arrayAccess
        + ", associateAccess=" + associateAccess
        + ", propertyAccess=" + propertyAccess
        + ", numberAsValue=" + numberAsValue
        + ", stringAsValue=" + stringAsValue
        + ", exceptionMapper=" + exceptionMapper
        + ", operatorMap=" + operatorMap
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExpressionFactory} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExpressionFactory instance
   */
  public static ImmutableExpressionFactory copyOf(ExpressionFactory instance) {
    if (instance instanceof ImmutableExpressionFactory) {
      return (ImmutableExpressionFactory) instance;
    }
    return ImmutableExpressionFactory.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExpressionFactory ImmutableExpressionFactory}.
   * <pre>
   * ImmutableExpressionFactory.builder()
   *    .mathContext(java.math.MathContext) // optional {@link ExpressionFactory#mathContext() mathContext}
   *    .zoneId(java.time.ZoneId) // optional {@link ExpressionFactory#zoneId() zoneId}
   *    .constants(de.flapdoodle.eval.core.VariableResolver) // required {@link ExpressionFactory#constants() constants}
   *    .evaluatables(de.flapdoodle.eval.core.evaluables.TypedEvaluableByName) // required {@link ExpressionFactory#evaluatables() evaluatables}
   *    .arrayAccess(de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments) // required {@link ExpressionFactory#arrayAccess() arrayAccess}
   *    .associateAccess(de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments) // required {@link ExpressionFactory#associateAccess() associateAccess}
   *    .propertyAccess(de.flapdoodle.eval.core.evaluables.TypedEvaluableByNumberOfArguments) // required {@link ExpressionFactory#propertyAccess() propertyAccess}
   *    .numberAsValue(de.flapdoodle.eval.core.NumberAsValue) // required {@link ExpressionFactory#numberAsValue() numberAsValue}
   *    .stringAsValue(de.flapdoodle.eval.core.StringAsValue) // required {@link ExpressionFactory#stringAsValue() stringAsValue}
   *    .exceptionMapper(de.flapdoodle.eval.core.tree.EvaluableExceptionMapper) // required {@link ExpressionFactory#exceptionMapper() exceptionMapper}
   *    .operatorMap(de.flapdoodle.eval.core.evaluables.OperatorMap) // required {@link ExpressionFactory#operatorMap() operatorMap}
   *    .build();
   * </pre>
   * @return A new ImmutableExpressionFactory builder
   */
  public static ImmutableExpressionFactory.Builder builder() {
    return new ImmutableExpressionFactory.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExpressionFactory ImmutableExpressionFactory}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExpressionFactory", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONSTANTS = 0x1L;
    private static final long INIT_BIT_EVALUATABLES = 0x2L;
    private static final long INIT_BIT_ARRAY_ACCESS = 0x4L;
    private static final long INIT_BIT_ASSOCIATE_ACCESS = 0x8L;
    private static final long INIT_BIT_PROPERTY_ACCESS = 0x10L;
    private static final long INIT_BIT_NUMBER_AS_VALUE = 0x20L;
    private static final long INIT_BIT_STRING_AS_VALUE = 0x40L;
    private static final long INIT_BIT_EXCEPTION_MAPPER = 0x80L;
    private static final long INIT_BIT_OPERATOR_MAP = 0x100L;
    private long initBits = 0x1ffL;

    private MathContext mathContext;
    private ZoneId zoneId;
    private VariableResolver constants;
    private TypedEvaluableByName evaluatables;
    private TypedEvaluableByNumberOfArguments arrayAccess;
    private TypedEvaluableByNumberOfArguments associateAccess;
    private TypedEvaluableByNumberOfArguments propertyAccess;
    private NumberAsValue numberAsValue;
    private StringAsValue stringAsValue;
    private EvaluableExceptionMapper exceptionMapper;
    private OperatorMap operatorMap;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExpressionFactory} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExpressionFactory instance) {
      Objects.requireNonNull(instance, "instance");
      this.mathContext(instance.mathContext());
      this.zoneId(instance.zoneId());
      this.constants(instance.constants());
      this.evaluatables(instance.evaluatables());
      this.arrayAccess(instance.arrayAccess());
      this.associateAccess(instance.associateAccess());
      this.propertyAccess(instance.propertyAccess());
      this.numberAsValue(instance.numberAsValue());
      this.stringAsValue(instance.stringAsValue());
      this.exceptionMapper(instance.exceptionMapper());
      this.operatorMap(instance.operatorMap());
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#mathContext() mathContext} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ExpressionFactory#mathContext() mathContext}.</em>
     * @param mathContext The value for mathContext 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder mathContext(MathContext mathContext) {
      this.mathContext = Objects.requireNonNull(mathContext, "mathContext");
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#zoneId() zoneId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ExpressionFactory#zoneId() zoneId}.</em>
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder zoneId(ZoneId zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#constants() constants} attribute.
     * @param constants The value for constants 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder constants(VariableResolver constants) {
      this.constants = Objects.requireNonNull(constants, "constants");
      initBits &= ~INIT_BIT_CONSTANTS;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#evaluatables() evaluatables} attribute.
     * @param evaluatables The value for evaluatables 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder evaluatables(TypedEvaluableByName evaluatables) {
      this.evaluatables = Objects.requireNonNull(evaluatables, "evaluatables");
      initBits &= ~INIT_BIT_EVALUATABLES;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#arrayAccess() arrayAccess} attribute.
     * @param arrayAccess The value for arrayAccess 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arrayAccess(TypedEvaluableByNumberOfArguments arrayAccess) {
      this.arrayAccess = Objects.requireNonNull(arrayAccess, "arrayAccess");
      initBits &= ~INIT_BIT_ARRAY_ACCESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#associateAccess() associateAccess} attribute.
     * @param associateAccess The value for associateAccess 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder associateAccess(TypedEvaluableByNumberOfArguments associateAccess) {
      this.associateAccess = Objects.requireNonNull(associateAccess, "associateAccess");
      initBits &= ~INIT_BIT_ASSOCIATE_ACCESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#propertyAccess() propertyAccess} attribute.
     * @param propertyAccess The value for propertyAccess 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder propertyAccess(TypedEvaluableByNumberOfArguments propertyAccess) {
      this.propertyAccess = Objects.requireNonNull(propertyAccess, "propertyAccess");
      initBits &= ~INIT_BIT_PROPERTY_ACCESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#numberAsValue() numberAsValue} attribute.
     * @param numberAsValue The value for numberAsValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder numberAsValue(NumberAsValue numberAsValue) {
      this.numberAsValue = Objects.requireNonNull(numberAsValue, "numberAsValue");
      initBits &= ~INIT_BIT_NUMBER_AS_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#stringAsValue() stringAsValue} attribute.
     * @param stringAsValue The value for stringAsValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stringAsValue(StringAsValue stringAsValue) {
      this.stringAsValue = Objects.requireNonNull(stringAsValue, "stringAsValue");
      initBits &= ~INIT_BIT_STRING_AS_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#exceptionMapper() exceptionMapper} attribute.
     * @param exceptionMapper The value for exceptionMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exceptionMapper(EvaluableExceptionMapper exceptionMapper) {
      this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper");
      initBits &= ~INIT_BIT_EXCEPTION_MAPPER;
      return this;
    }

    /**
     * Initializes the value for the {@link ExpressionFactory#operatorMap() operatorMap} attribute.
     * @param operatorMap The value for operatorMap 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder operatorMap(OperatorMap operatorMap) {
      this.operatorMap = Objects.requireNonNull(operatorMap, "operatorMap");
      initBits &= ~INIT_BIT_OPERATOR_MAP;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExpressionFactory ImmutableExpressionFactory}.
     * @return An immutable instance of ExpressionFactory
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExpressionFactory build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExpressionFactory(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONSTANTS) != 0) attributes.add("constants");
      if ((initBits & INIT_BIT_EVALUATABLES) != 0) attributes.add("evaluatables");
      if ((initBits & INIT_BIT_ARRAY_ACCESS) != 0) attributes.add("arrayAccess");
      if ((initBits & INIT_BIT_ASSOCIATE_ACCESS) != 0) attributes.add("associateAccess");
      if ((initBits & INIT_BIT_PROPERTY_ACCESS) != 0) attributes.add("propertyAccess");
      if ((initBits & INIT_BIT_NUMBER_AS_VALUE) != 0) attributes.add("numberAsValue");
      if ((initBits & INIT_BIT_STRING_AS_VALUE) != 0) attributes.add("stringAsValue");
      if ((initBits & INIT_BIT_EXCEPTION_MAPPER) != 0) attributes.add("exceptionMapper");
      if ((initBits & INIT_BIT_OPERATOR_MAP) != 0) attributes.add("operatorMap");
      return "Cannot build ExpressionFactory, some of required attributes are not set " + attributes;
    }
  }
}
