package de.flapdoodle.eval.core.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Variables}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariables.builder()}.
 */
@Generated(from = "Variables", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableVariables extends Variables {
  private final List<Variable> list;
  private transient final Map<String, Integer> nameHashMap;
  private transient final Set<String> names;

  private ImmutableVariables(List<Variable> list) {
    this.list = list;
    this.nameHashMap = initShim.nameHashMap();
    this.names = initShim.names();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Variables", generator = "Immutables")
  private final class InitShim {
    private byte nameHashMapBuildStage = STAGE_UNINITIALIZED;
    private Map<String, Integer> nameHashMap;

    Map<String, Integer> nameHashMap() {
      if (nameHashMapBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nameHashMapBuildStage == STAGE_UNINITIALIZED) {
        nameHashMapBuildStage = STAGE_INITIALIZING;
        this.nameHashMap = Objects.requireNonNull(ImmutableVariables.super.nameHashMap(), "nameHashMap");
        nameHashMapBuildStage = STAGE_INITIALIZED;
      }
      return this.nameHashMap;
    }

    private byte namesBuildStage = STAGE_UNINITIALIZED;
    private Set<String> names;

    Set<String> names() {
      if (namesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (namesBuildStage == STAGE_UNINITIALIZED) {
        namesBuildStage = STAGE_INITIALIZING;
        this.names = Objects.requireNonNull(ImmutableVariables.super.names(), "names");
        namesBuildStage = STAGE_INITIALIZED;
      }
      return this.names;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (nameHashMapBuildStage == STAGE_INITIALIZING) attributes.add("nameHashMap");
      if (namesBuildStage == STAGE_INITIALIZING) attributes.add("names");
      return "Cannot build Variables, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public List<Variable> list() {
    return list;
  }

  /**
   * @return The computed-at-construction value of the {@code nameHashMap} attribute
   */
  @Override
  public Map<String, Integer> nameHashMap() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.nameHashMap()
        : this.nameHashMap;
  }

  /**
   * @return The computed-at-construction value of the {@code names} attribute
   */
  @Override
  public Set<String> names() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.names()
        : this.names;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Variables#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVariables withList(Variable... elements) {
    List<Variable> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableVariables(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Variables#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableVariables withList(Iterable<? extends Variable> elements) {
    if (this.list == elements) return this;
    List<Variable> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableVariables(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariables} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariables
        && equalTo(0, (ImmutableVariables) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariables another) {
    return list.equals(another.list)
        && nameHashMap.equals(another.nameHashMap)
        && names.equals(another.names);
  }

  /**
   * Computes a hash code from attributes: {@code list}, {@code nameHashMap}, {@code names}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + list.hashCode();
    h += (h << 5) + nameHashMap.hashCode();
    h += (h << 5) + names.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Variables} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Variables{"
        + "list=" + list
        + ", nameHashMap=" + nameHashMap
        + ", names=" + names
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Variables} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Variables instance
   */
  public static ImmutableVariables copyOf(Variables instance) {
    if (instance instanceof ImmutableVariables) {
      return (ImmutableVariables) instance;
    }
    return ImmutableVariables.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariables ImmutableVariables}.
   * <pre>
   * ImmutableVariables.builder()
   *    .addList|addAllList(de.flapdoodle.eval.core.tree.Variable) // {@link Variables#list() list} elements
   *    .build();
   * </pre>
   * @return A new ImmutableVariables builder
   */
  public static ImmutableVariables.Builder builder() {
    return new ImmutableVariables.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariables ImmutableVariables}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Variables", generator = "Immutables")
  public static final class Builder {
    private List<Variable> list = new ArrayList<Variable>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Variables} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Variables instance) {
      Objects.requireNonNull(instance, "instance");
      addAllList(instance.list());
      return this;
    }

    /**
     * Adds one element to {@link Variables#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addList(Variable element) {
      this.list.add(Objects.requireNonNull(element, "list element"));
      return this;
    }

    /**
     * Adds elements to {@link Variables#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addList(Variable... elements) {
      for (Variable element : elements) {
        this.list.add(Objects.requireNonNull(element, "list element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Variables#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder list(Iterable<? extends Variable> elements) {
      this.list.clear();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link Variables#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllList(Iterable<? extends Variable> elements) {
      for (Variable element : elements) {
        this.list.add(Objects.requireNonNull(element, "list element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariables ImmutableVariables}.
     * @return An immutable instance of Variables
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariables build() {
      return new ImmutableVariables(createUnmodifiableList(true, list));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
