package de.flapdoodle.eval.example;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Value.DurationValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDurationValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDurationValue.of()}.
 */
@Generated(from = "Value.DurationValue", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableDurationValue extends Value.DurationValue {
  private final Duration wrapped;

  private ImmutableDurationValue(Duration wrapped) {
    this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
  }

  private ImmutableDurationValue(ImmutableDurationValue original, Duration wrapped) {
    this.wrapped = wrapped;
  }

  /**
   * @return The value of the {@code wrapped} attribute
   */
  @Override
  public Duration wrapped() {
    return wrapped;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Value.DurationValue#wrapped() wrapped} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for wrapped
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDurationValue withWrapped(Duration value) {
    if (this.wrapped == value) return this;
    Duration newValue = Objects.requireNonNull(value, "wrapped");
    return new ImmutableDurationValue(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDurationValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDurationValue
        && equalTo(0, (ImmutableDurationValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDurationValue another) {
    return wrapped.equals(another.wrapped);
  }

  /**
   * Computes a hash code from attributes: {@code wrapped}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + wrapped.hashCode();
    return h;
  }

  /**
   * Construct a new immutable {@code DurationValue} instance.
   * @param wrapped The value for the {@code wrapped} attribute
   * @return An immutable DurationValue instance
   */
  public static ImmutableDurationValue of(Duration wrapped) {
    return new ImmutableDurationValue(wrapped);
  }

  /**
   * Creates an immutable copy of a {@link Value.DurationValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DurationValue instance
   */
  public static ImmutableDurationValue copyOf(Value.DurationValue instance) {
    if (instance instanceof ImmutableDurationValue) {
      return (ImmutableDurationValue) instance;
    }
    return ImmutableDurationValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDurationValue ImmutableDurationValue}.
   * <pre>
   * ImmutableDurationValue.builder()
   *    .wrapped(java.time.Duration) // required {@link Value.DurationValue#wrapped() wrapped}
   *    .build();
   * </pre>
   * @return A new ImmutableDurationValue builder
   */
  public static ImmutableDurationValue.Builder builder() {
    return new ImmutableDurationValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDurationValue ImmutableDurationValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Value.DurationValue", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_WRAPPED = 0x1L;
    private long initBits = 0x1L;

    private Duration wrapped;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DurationValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Value.DurationValue instance) {
      Objects.requireNonNull(instance, "instance");
      this.wrapped(instance.wrapped());
      return this;
    }

    /**
     * Initializes the value for the {@link Value.DurationValue#wrapped() wrapped} attribute.
     * @param wrapped The value for wrapped 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder wrapped(Duration wrapped) {
      this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
      initBits &= ~INIT_BIT_WRAPPED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDurationValue ImmutableDurationValue}.
     * @return An immutable instance of DurationValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDurationValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDurationValue(null, wrapped);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WRAPPED) != 0) attributes.add("wrapped");
      return "Cannot build DurationValue, some of required attributes are not set " + attributes;
    }
  }
}
