/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.core;

import de.flapdoodle.eval.core.MapBasedVariableTypeResolver;
import de.flapdoodle.reflection.TypeInfo;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MapBasedVariableTypeResolver", generator="Immutables")
public final class ImmutableMapBasedVariableTypeResolver
extends MapBasedVariableTypeResolver {
    private final Map<String, TypeInfo<?>> variables;

    private ImmutableMapBasedVariableTypeResolver(Map<String, TypeInfo<?>> variables) {
        this.variables = variables;
    }

    @Override
    protected Map<String, TypeInfo<?>> variables() {
        return this.variables;
    }

    public final ImmutableMapBasedVariableTypeResolver withVariables(Map<String, ? extends TypeInfo<?>> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, ? extends TypeInfo<?>> newValue = ImmutableMapBasedVariableTypeResolver.createUnmodifiableMap(true, false, entries);
        return new ImmutableMapBasedVariableTypeResolver(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMapBasedVariableTypeResolver && this.equalTo(0, (ImmutableMapBasedVariableTypeResolver)another);
    }

    private boolean equalTo(int synthetic, ImmutableMapBasedVariableTypeResolver another) {
        return this.variables.equals(another.variables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.variables.hashCode();
        return h;
    }

    public String toString() {
        return "MapBasedVariableTypeResolver{variables=" + this.variables + "}";
    }

    public static ImmutableMapBasedVariableTypeResolver copyOf(MapBasedVariableTypeResolver instance) {
        if (instance instanceof ImmutableMapBasedVariableTypeResolver) {
            return (ImmutableMapBasedVariableTypeResolver)instance;
        }
        return ImmutableMapBasedVariableTypeResolver.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="MapBasedVariableTypeResolver", generator="Immutables")
    public static final class Builder {
        private Map<String, TypeInfo<?>> variables = new LinkedHashMap();

        private Builder() {
        }

        public final Builder from(MapBasedVariableTypeResolver instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllVariables(instance.variables());
            return this;
        }

        public final Builder putVariables(String key, TypeInfo<?> value) {
            this.variables.put(Objects.requireNonNull(key, "variables key"), Objects.requireNonNull(value, value == null ? "variables value for key: " + key : null));
            return this;
        }

        public final Builder putVariables(Map.Entry<String, ? extends TypeInfo<?>> entry) {
            String k = entry.getKey();
            TypeInfo<?> v = entry.getValue();
            this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, v == null ? "variables value for key: " + k : null));
            return this;
        }

        public final Builder variables(Map<String, ? extends TypeInfo<?>> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends TypeInfo<?>> entries) {
            for (Map.Entry<String, TypeInfo<?>> e : entries.entrySet()) {
                String k = e.getKey();
                TypeInfo<?> v = e.getValue();
                this.variables.put(Objects.requireNonNull(k, "variables key"), Objects.requireNonNull(v, v == null ? "variables value for key: " + k : null));
            }
            return this;
        }

        public ImmutableMapBasedVariableTypeResolver build() {
            return new ImmutableMapBasedVariableTypeResolver(ImmutableMapBasedVariableTypeResolver.createUnmodifiableMap(false, false, this.variables));
        }
    }
}

