/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.eval.example.evaluables.arithmetic;

import de.flapdoodle.eval.core.EvaluationContext;
import de.flapdoodle.eval.core.VariableResolver;
import de.flapdoodle.eval.core.evaluables.Parameter;
import de.flapdoodle.eval.core.evaluables.TypedEvaluable;
import de.flapdoodle.eval.core.evaluables.TypedEvaluables;
import de.flapdoodle.eval.core.exceptions.EvaluationException;
import de.flapdoodle.eval.core.parser.Token;
import de.flapdoodle.eval.core.validation.ParameterValidator;
import de.flapdoodle.eval.example.Value;
import de.flapdoodle.eval.example.evaluables.validation.NumberValidator;
import java.math.BigDecimal;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Trigonometric
extends TypedEvaluables.Wrapper {
    private Trigonometric(TypedEvaluables delegate) {
        super(delegate);
    }

    @SafeVarargs
    private static Trigonometric of(AbstractTransformation transformation, ParameterValidator<Value.NumberValue> ... validators) {
        return new Trigonometric(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Parameter.of(Value.NumberValue.class).withValidators(validators), transformation)).build());
    }

    private static Trigonometric of(AbstractMerge transformation) {
        return new Trigonometric(TypedEvaluables.builder().addList((TypedEvaluable<?>)TypedEvaluable.of(Value.NumberValue.class, Value.NumberValue.class, Value.NumberValue.class, transformation)).build());
    }

    public static Trigonometric acos() {
        return Trigonometric.of(new Acos(), new ParameterValidator[0]);
    }

    public static Trigonometric acosH() {
        return Trigonometric.of(new AcosH(), NumberValidator.greaterOrEqualThan(BigDecimal.ONE));
    }

    public static Trigonometric acosR() {
        return Trigonometric.of(new AcosR(), new ParameterValidator[0]);
    }

    public static Trigonometric acot() {
        return Trigonometric.of(new Acot(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric acotH() {
        return Trigonometric.of(new AcotH(), new ParameterValidator[0]);
    }

    public static Trigonometric acotR() {
        return Trigonometric.of(new AcotR(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric asin() {
        return Trigonometric.of(new Asin(), NumberValidator.greaterOrEqualThan(BigDecimal.valueOf(-1L), "Illegal x < -1 for asin(x): x = %s"), NumberValidator.smallerOrEqualThan(BigDecimal.ONE, "Illegal x > 1 for asin(x): x = %s"));
    }

    public static Trigonometric asinH() {
        return Trigonometric.of(new AsinH(), new ParameterValidator[0]);
    }

    public static Trigonometric asinR() {
        return Trigonometric.of(new AsinR(), NumberValidator.greaterOrEqualThan(BigDecimal.valueOf(-1L), "Illegal x < -1 for asinR(x): x = %s"), NumberValidator.smallerOrEqualThan(BigDecimal.ONE, "Illegal x > 1 for asinR(x): x = %s"));
    }

    public static Trigonometric atan() {
        return Trigonometric.of(new Atan(), new ParameterValidator[0]);
    }

    public static Trigonometric atanH() {
        return Trigonometric.of(new AtanH(), NumberValidator.greaterThan(BigDecimal.valueOf(-1L), "Illegal x < -1 for atanH(x): x = %s"), NumberValidator.smallerThan(BigDecimal.ONE, "Illegal x > 1 for atanH(x): x = %s"));
    }

    public static Trigonometric atanR() {
        return Trigonometric.of(new AtanR(), new ParameterValidator[0]);
    }

    public static Trigonometric atan2() {
        return Trigonometric.of(new Atan2());
    }

    public static Trigonometric atan2R() {
        return Trigonometric.of(new Atan2R());
    }

    public static Trigonometric cos() {
        return Trigonometric.of(new Cos(), new ParameterValidator[0]);
    }

    public static Trigonometric cosH() {
        return Trigonometric.of(new CosH(), new ParameterValidator[0]);
    }

    public static Trigonometric cosR() {
        return Trigonometric.of(new CosR(), new ParameterValidator[0]);
    }

    public static Trigonometric cot() {
        return Trigonometric.of(new Cot(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric cotH() {
        return Trigonometric.of(new CotH(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric cotR() {
        return Trigonometric.of(new CotR(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric csc() {
        return Trigonometric.of(new Csc(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric cscH() {
        return Trigonometric.of(new CscH(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric cscR() {
        return Trigonometric.of(new CscR(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric deg() {
        return Trigonometric.of(new Deg(), new ParameterValidator[0]);
    }

    public static Trigonometric rad() {
        return Trigonometric.of(new Rad(), new ParameterValidator[0]);
    }

    public static Trigonometric sin() {
        return Trigonometric.of(new Sin(), new ParameterValidator[0]);
    }

    public static Trigonometric sinH() {
        return Trigonometric.of(new SinH(), new ParameterValidator[0]);
    }

    public static Trigonometric sinR() {
        return Trigonometric.of(new SinR(), new ParameterValidator[0]);
    }

    public static Trigonometric sec() {
        return Trigonometric.of(new Sec(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric secH() {
        return Trigonometric.of(new SecH(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric secR() {
        return Trigonometric.of(new SecR(), NumberValidator.isNot(BigDecimal.ZERO));
    }

    public static Trigonometric tan() {
        return Trigonometric.of(new Tan(), new ParameterValidator[0]);
    }

    public static Trigonometric tanH() {
        return Trigonometric.of(new TanH(), new ParameterValidator[0]);
    }

    public static Trigonometric tanR() {
        return Trigonometric.of(new TanR(), new ParameterValidator[0]);
    }

    public static class TanR
    extends AbstractTransformation {
        public TanR() {
            super(Math::tan);
        }
    }

    public static class TanH
    extends AbstractTransformation {
        public TanH() {
            super(Math::tanh);
        }
    }

    public static class Tan
    extends AbstractTransformation {
        public Tan() {
            super(v -> Math.tan(Math.toRadians(v)));
        }
    }

    public static class SecR
    extends AbstractTransformation {
        public SecR() {
            super(v -> 1.0 / Math.cos(v));
        }
    }

    public static class SecH
    extends AbstractTransformation {
        public SecH() {
            super(v -> 1.0 / Math.cosh(v));
        }
    }

    public static class Sec
    extends AbstractTransformation {
        public Sec() {
            super(v -> 1.0 / Math.cos(Math.toRadians(v)));
        }
    }

    public static class SinR
    extends AbstractTransformation {
        public SinR() {
            super(Math::sin);
        }
    }

    public static class SinH
    extends AbstractTransformation {
        public SinH() {
            super(Math::sinh);
        }
    }

    public static class Sin
    extends AbstractTransformation {
        public Sin() {
            super(v -> Math.sin(Math.toRadians(v)));
        }
    }

    public static class Rad
    extends AbstractTransformation {
        public Rad() {
            super(Math::toRadians);
        }
    }

    public static class Deg
    extends AbstractTransformation {
        public Deg() {
            super(Math::toDegrees);
        }
    }

    public static class CscR
    extends AbstractTransformation {
        public CscR() {
            super(v -> 1.0 / Math.sin(v));
        }
    }

    public static class CscH
    extends AbstractTransformation {
        public CscH() {
            super(v -> 1.0 / Math.sinh(v));
        }
    }

    public static class Csc
    extends AbstractTransformation {
        public Csc() {
            super(v -> 1.0 / Math.sin(Math.toRadians(v)));
        }
    }

    public static class CotR
    extends AbstractTransformation {
        public CotR() {
            super(v -> 1.0 / Math.tan(v));
        }
    }

    public static class CotH
    extends AbstractTransformation {
        public CotH() {
            super(v -> 1.0 / Math.tanh(v));
        }
    }

    public static class Cot
    extends AbstractTransformation {
        public Cot() {
            super(v -> 1.0 / Math.tan(Math.toRadians(v)));
        }
    }

    public static class CosR
    extends AbstractTransformation {
        public CosR() {
            super(Math::cos);
        }
    }

    public static class CosH
    extends AbstractTransformation {
        public CosH() {
            super(Math::cosh);
        }
    }

    public static class Cos
    extends AbstractTransformation {
        public Cos() {
            super(v -> Math.cos(Math.toRadians(v)));
        }
    }

    public static class Atan2R
    extends AbstractMerge {
        public Atan2R() {
            super(Math::atan2);
        }
    }

    public static class Atan2
    extends AbstractMerge {
        public Atan2() {
            super((a, b) -> Math.toDegrees(Math.atan2(a, b)));
        }
    }

    public static class AtanR
    extends AbstractTransformation {
        public AtanR() {
            super(Math::atan);
        }
    }

    public static class AtanH
    extends AbstractTransformation {
        public AtanH() {
            super(v -> 0.5 * Math.log((1.0 + v) / (1.0 - v)));
        }
    }

    public static class Atan
    extends AbstractTransformation {
        public Atan() {
            super(v -> Math.toDegrees(Math.atan(v)));
        }
    }

    public static class AsinR
    extends AbstractTransformation {
        public AsinR() {
            super(Math::asin);
        }
    }

    public static class AsinH
    extends AbstractTransformation {
        public AsinH() {
            super(v -> Math.log(v + Math.sqrt(Math.pow(v, 2.0) + 1.0)));
        }
    }

    public static class Asin
    extends AbstractTransformation {
        public Asin() {
            super(v -> Math.toDegrees(Math.asin(v)));
        }
    }

    public static class AcotR
    extends AbstractTransformation {
        public AcotR() {
            super(v -> 1.5707963267948966 - Math.atan(v));
        }
    }

    public static class AcotH
    extends AbstractTransformation {
        public AcotH() {
            super(v -> Math.log((v + 1.0) / (v - 1.0)) * 0.5);
        }
    }

    public static class Acot
    extends AbstractTransformation {
        public Acot() {
            super(v -> Math.toDegrees(1.5707963267948966 - Math.atan(v)));
        }
    }

    public static class AcosH
    extends AbstractTransformation {
        public AcosH() {
            super(v -> Math.log(v + Math.sqrt(Math.pow(v, 2.0) - 1.0)));
        }
    }

    public static class AcosR
    extends AbstractTransformation {
        public AcosR() {
            super(Math::acos);
        }
    }

    public static class Acos
    extends AbstractTransformation {
        public Acos() {
            super(v -> Math.toDegrees(Math.acos(v)));
        }
    }

    protected static abstract class AbstractMerge
    implements TypedEvaluable.Arg2<Value.NumberValue, Value.NumberValue, Value.NumberValue> {
        private final BiFunction<Double, Double, Double> merge;

        public AbstractMerge(BiFunction<Double, Double, Double> merge) {
            this.merge = merge;
        }

        @Override
        public final Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue first, Value.NumberValue second) throws EvaluationException {
            return Value.of(this.merge.apply(((BigDecimal)first.wrapped()).doubleValue(), ((BigDecimal)second.wrapped()).doubleValue()));
        }
    }

    protected static abstract class AbstractTransformation
    implements TypedEvaluable.Arg1<Value.NumberValue, Value.NumberValue> {
        private final Function<Double, Double> transformation;

        public AbstractTransformation(Function<Double, Double> transformation) {
            this.transformation = transformation;
        }

        @Override
        public final Value.NumberValue evaluate(VariableResolver variableResolver, EvaluationContext evaluationContext, Token token, Value.NumberValue argument) throws EvaluationException {
            return Value.of(this.transformation.apply(((BigDecimal)argument.wrapped()).doubleValue()));
        }
    }
}

